/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.workflows.prehandle;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.TransactionID;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.hapi.util.HapiUtils;
import com.hedera.node.app.hapi.utils.keys.KeyUtils;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.service.token.impl.util.TokenHandlerHelper;
import com.hedera.node.app.spi.info.NodeInfo;
import com.hedera.node.app.spi.validation.Validations;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.PreHandleContext;
import com.hedera.node.app.spi.workflows.TransactionKeys;
import com.hedera.node.app.store.ReadableStoreFactory;
import com.hedera.node.app.workflows.TransactionChecker;
import com.hedera.node.app.workflows.dispatcher.TransactionDispatcher;
import com.hedera.node.app.workflows.purechecks.PureChecksContextImpl;
import com.hedera.node.config.data.AccountsConfig;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.config.api.Configuration;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.UnaryOperator;

public class PreHandleContextImpl
implements PreHandleContext {
    private final ReadableAccountStore accountStore;
    private final TransactionBody txn;
    private final AccountID payerId;
    private final Key payerKey;
    private final Set<Key> requiredNonPayerKeys = new LinkedHashSet<Key>();
    private final Set<Account> requiredHollowAccounts = new LinkedHashSet<Account>();
    private final Set<Key> optionalNonPayerKeys = new LinkedHashSet<Key>();
    private final Set<Account> optionalHollowAccounts = new LinkedHashSet<Account>();
    private final ReadableStoreFactory storeFactory;
    private final NodeInfo creatorInfo;
    private final Configuration configuration;
    private final TransactionDispatcher dispatcher;
    private final boolean isUserTx;
    private final TransactionChecker transactionChecker;

    public PreHandleContextImpl(@NonNull ReadableStoreFactory storeFactory, @NonNull TransactionBody txn, @NonNull Configuration configuration, @NonNull TransactionDispatcher dispatcher, @NonNull TransactionChecker transactionChecker, @NonNull NodeInfo creatorInfo) throws PreCheckException {
        this(storeFactory, txn, txn.transactionIDOrElse(TransactionID.DEFAULT).accountIDOrElse(AccountID.DEFAULT), creatorInfo, configuration, dispatcher, true, transactionChecker);
    }

    public PreHandleContextImpl(@NonNull ReadableStoreFactory storeFactory, @NonNull TransactionBody txn, @NonNull AccountID payer, @NonNull Configuration configuration, @NonNull TransactionDispatcher dispatcher, @NonNull TransactionChecker transactionChecker, @NonNull NodeInfo creatorInfo) throws PreCheckException {
        this(storeFactory, txn, payer, creatorInfo, configuration, dispatcher, false, transactionChecker);
    }

    private PreHandleContextImpl(@NonNull ReadableStoreFactory storeFactory, @NonNull TransactionBody txn, @NonNull AccountID payerId, @NonNull NodeInfo creatorInfo, @NonNull Configuration configuration, @NonNull TransactionDispatcher dispatcher, boolean isUserTx, @NonNull TransactionChecker transactionChecker) throws PreCheckException {
        this.storeFactory = Objects.requireNonNull(storeFactory, "storeFactory must not be null.");
        this.txn = Objects.requireNonNull(txn, "txn must not be null!");
        this.payerId = Objects.requireNonNull(payerId, "payer must not be null!");
        this.creatorInfo = Objects.requireNonNull(creatorInfo);
        this.configuration = Objects.requireNonNull(configuration, "configuration must not be null!");
        this.dispatcher = Objects.requireNonNull(dispatcher, "dispatcher must not be null!");
        this.isUserTx = isUserTx;
        this.accountStore = storeFactory.getStore(ReadableAccountStore.class);
        Account payer = (Account)Validations.mustExist((Object)this.accountStore.getAccountById(payerId), (ResponseCodeEnum)ResponseCodeEnum.INVALID_PAYER_ACCOUNT_ID);
        this.payerKey = payer.keyOrThrow();
        this.transactionChecker = Objects.requireNonNull(transactionChecker, "transactionChecker must not be null!");
    }

    @NonNull
    public <C> C createStore(@NonNull Class<C> storeInterface) {
        return this.storeFactory.getStore(storeInterface);
    }

    @NonNull
    public TransactionBody body() {
        return this.txn;
    }

    @NonNull
    public AccountID payer() {
        return this.payerId;
    }

    @NonNull
    public Configuration configuration() {
        return this.configuration;
    }

    public boolean isUserTransaction() {
        return this.isUserTx;
    }

    @NonNull
    public Set<Key> requiredNonPayerKeys() {
        return Collections.unmodifiableSet(this.requiredNonPayerKeys);
    }

    @NonNull
    public Set<Key> optionalNonPayerKeys() {
        return Collections.unmodifiableSet(this.optionalNonPayerKeys);
    }

    @NonNull
    public PreHandleContext optionalKey(@NonNull Key key) throws PreCheckException {
        TokenHandlerHelper.verifyNotEmptyKey((Key)key, (ResponseCodeEnum)ResponseCodeEnum.INVALID_ACCOUNT_ID);
        if (!key.equals((Object)this.payerKey) && KeyUtils.isValid((Key)key)) {
            this.optionalNonPayerKeys.add(key);
        }
        return this;
    }

    @NonNull
    public PreHandleContext optionalKeys(@NonNull Set<Key> keys) throws PreCheckException {
        for (Key nextKey : keys) {
            this.optionalKey(nextKey);
        }
        return this;
    }

    @NonNull
    public Set<Account> optionalHollowAccounts() {
        return Collections.unmodifiableSet(this.optionalHollowAccounts);
    }

    @NonNull
    public PreHandleContext optionalSignatureForHollowAccount(@NonNull Account hollowAccount) {
        Objects.requireNonNull(hollowAccount);
        AccountID id = hollowAccount.accountId();
        if (!HapiUtils.isHollow((Account)hollowAccount)) {
            throw new IllegalArgumentException("Account %d.%d.%d is not a hollow account".formatted(id.shardNum(), id.realmNum(), id.accountNum()));
        }
        this.optionalHollowAccounts.add(hollowAccount);
        return this;
    }

    @NonNull
    public Set<Account> requiredHollowAccounts() {
        return Collections.unmodifiableSet(this.requiredHollowAccounts);
    }

    @NonNull
    public Key payerKey() {
        return this.payerKey;
    }

    @NonNull
    public PreHandleContext requireKey(@NonNull Key key) {
        if (!key.equals((Object)this.payerKey) && KeyUtils.isValid((Key)key)) {
            this.requiredNonPayerKeys.add(key);
        }
        return this;
    }

    @NonNull
    public PreHandleContext requireKeyOrThrow(@Nullable Key key, @NonNull ResponseCodeEnum responseCode) throws PreCheckException {
        Objects.requireNonNull(responseCode);
        if (!KeyUtils.isValid((Key)key)) {
            throw new PreCheckException(responseCode);
        }
        TokenHandlerHelper.verifyNotEmptyKey((Key)key, (ResponseCodeEnum)responseCode);
        return this.requireKey(key);
    }

    @NonNull
    public PreHandleContext requireKeyOrThrow(@Nullable AccountID accountID, @NonNull ResponseCodeEnum responseCode) throws PreCheckException {
        Objects.requireNonNull(responseCode);
        return this.requireKey(accountID, responseCode, false, null, false);
    }

    @NonNull
    public PreHandleContext requireKeyOrThrowOnDeleted(@Nullable AccountID accountID, @NonNull ResponseCodeEnum failureStatus) throws PreCheckException {
        Objects.requireNonNull(failureStatus);
        return this.requireKey(accountID, failureStatus, false, null, true);
    }

    @NonNull
    public PreHandleContext requireKeyOrThrow(@Nullable AccountID accountID, @NonNull UnaryOperator<Key> finisher, @NonNull ResponseCodeEnum failureStatus) throws PreCheckException {
        Objects.requireNonNull(finisher);
        Objects.requireNonNull(failureStatus);
        return this.requireKey(accountID, failureStatus, false, finisher, true);
    }

    @NonNull
    public PreHandleContext requireAliasedKeyOrThrow(@Nullable AccountID accountID, @NonNull ResponseCodeEnum responseCode) throws PreCheckException {
        Objects.requireNonNull(responseCode);
        return this.requireKey(accountID, responseCode, true, null, false);
    }

    @NonNull
    private PreHandleContext requireKey(@Nullable AccountID accountID, @NonNull ResponseCodeEnum responseCode, boolean allowAliasedIds, @Nullable UnaryOperator<Key> finisher, boolean failOnDeleted) throws PreCheckException {
        if (accountID == null) {
            throw new PreCheckException(responseCode);
        }
        if (accountID.equals((Object)this.payerId)) {
            return this;
        }
        Account account = allowAliasedIds ? this.accountStore.getAliasedAccountById(accountID) : this.accountStore.getAccountById(accountID);
        if (account == null) {
            throw new PreCheckException(responseCode);
        }
        if (failOnDeleted && account.deleted()) {
            throw new PreCheckException(ResponseCodeEnum.ACCOUNT_DELETED);
        }
        if (HapiUtils.isHollow((Account)account)) {
            this.requiredHollowAccounts.add(account);
            return this;
        }
        this.verifyNotStakingAccounts(account.accountIdOrThrow(), responseCode);
        Key key = account.keyOrThrow();
        if (!KeyUtils.isValid((Key)key)) {
            throw new PreCheckException(responseCode);
        }
        if (finisher != null) {
            key = (Key)finisher.apply(key);
        }
        return this.requireKey(key);
    }

    @NonNull
    public PreHandleContext requireKeyOrThrow(@Nullable ContractID accountID, @NonNull ResponseCodeEnum responseCode) throws PreCheckException {
        Objects.requireNonNull(responseCode);
        if (accountID == null) {
            throw new PreCheckException(responseCode);
        }
        Account account = this.accountStore.getContractById(accountID);
        if (account == null) {
            throw new PreCheckException(responseCode);
        }
        if (HapiUtils.isHollow((Account)account)) {
            this.requiredHollowAccounts.add(account);
            return this;
        }
        this.verifyNotStakingAccounts(account.accountIdOrThrow(), responseCode);
        Key key = account.key();
        if (!KeyUtils.isValid((Key)key)) {
            throw new PreCheckException(responseCode);
        }
        return this.requireKey(key);
    }

    @NonNull
    public PreHandleContext requireKeyIfReceiverSigRequired(@Nullable AccountID accountID, @NonNull ResponseCodeEnum responseCode) throws PreCheckException {
        Objects.requireNonNull(responseCode);
        if (accountID == null || accountID.equals((Object)AccountID.DEFAULT)) {
            return this;
        }
        Account account = this.accountStore.getAccountById(accountID);
        if (account == null) {
            throw new PreCheckException(responseCode);
        }
        if (!account.receiverSigRequired()) {
            return this;
        }
        if (HapiUtils.isHollow((Account)account)) {
            this.requiredHollowAccounts.add(account);
            return this;
        }
        this.verifyNotStakingAccounts(account.accountIdOrThrow(), responseCode);
        Key key = account.key();
        if (key == null || key.key().kind() == Key.KeyOneOfType.UNSET) {
            throw new PreCheckException(responseCode);
        }
        return this.requireKey(key);
    }

    @NonNull
    public PreHandleContext requireKeyIfReceiverSigRequired(@Nullable ContractID contractID, @NonNull ResponseCodeEnum responseCode) throws PreCheckException {
        Objects.requireNonNull(responseCode);
        if (contractID == null) {
            return this;
        }
        Account account = this.accountStore.getContractById(contractID);
        if (account == null) {
            throw new PreCheckException(responseCode);
        }
        if (!account.receiverSigRequired()) {
            return this;
        }
        if (HapiUtils.isHollow((Account)account)) {
            this.requiredHollowAccounts.add(account);
            return this;
        }
        this.verifyNotStakingAccounts(account.accountIdOrThrow(), responseCode);
        Key key = account.key();
        if (!KeyUtils.isValid((Key)key)) {
            throw new PreCheckException(responseCode);
        }
        return this.requireKey(key);
    }

    @NonNull
    public PreHandleContext requireSignatureForHollowAccount(@NonNull Account hollowAccount) {
        Objects.requireNonNull(hollowAccount);
        AccountID id = hollowAccount.accountId();
        if (!HapiUtils.isHollow((Account)hollowAccount)) {
            throw new IllegalArgumentException("Account %d.%d.%d is not a hollow account".formatted(id.shardNum(), id.realmNum(), id.accountNum()));
        }
        this.requiredHollowAccounts.add(hollowAccount);
        return this;
    }

    @NonNull
    public PreHandleContext requireSignatureForHollowAccountCreation(@NonNull Bytes hollowAccountAlias) {
        Objects.requireNonNull(hollowAccountAlias);
        this.requiredHollowAccounts.add(Account.newBuilder().accountId(AccountID.DEFAULT).key(HapiUtils.EMPTY_KEY_LIST).alias(hollowAccountAlias).build());
        return this;
    }

    @NonNull
    public TransactionKeys allKeysForTransaction(@NonNull TransactionBody body, @NonNull AccountID payerId) throws PreCheckException {
        PureChecksContextImpl pureChecksContext = new PureChecksContextImpl(body, this.dispatcher);
        this.dispatcher.dispatchPureChecks(pureChecksContext);
        PreHandleContextImpl context = new PreHandleContextImpl(this.storeFactory, body, payerId, this.configuration, this.dispatcher, this.transactionChecker, this.creatorInfo);
        try {
            this.dispatcher.dispatchPreHandle(context);
        }
        catch (PreCheckException ignored) {
            throw new PreCheckException(ResponseCodeEnum.UNRESOLVABLE_REQUIRED_SIGNERS);
        }
        return context;
    }

    public NodeInfo creatorInfo() {
        return this.creatorInfo;
    }

    public String toString() {
        return "PreHandleContextImpl{accountStore=" + String.valueOf(this.accountStore) + ", txn=" + String.valueOf(this.txn) + ", payerId=" + String.valueOf(this.payerId) + ", payerKey=" + String.valueOf(this.payerKey) + ", requiredNonPayerKeys=" + String.valueOf(this.requiredNonPayerKeys) + ", storeFactory=" + String.valueOf(this.storeFactory) + "}";
    }

    private void verifyNotStakingAccounts(@Nullable AccountID accountID, @NonNull ResponseCodeEnum responseCode) throws PreCheckException {
        AccountsConfig accountsConfig;
        long accountNum = accountID != null ? accountID.accountNum() : 0L;
        if (accountNum == (accountsConfig = (AccountsConfig)this.configuration.getConfigData(AccountsConfig.class)).stakingRewardAccount() || accountNum == accountsConfig.nodeRewardAccount()) {
            throw new PreCheckException(responseCode);
        }
    }
}

