/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http.media;

import io.helidon.common.GenericType;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Optional;

public interface ReadableEntity {
    public InputStream inputStream();

    default public <T> T as(Class<T> type) {
        return this.as(GenericType.create(type));
    }

    default public <T> Optional<T> asOptional(Class<T> type) {
        return this.asOptional(GenericType.create(type));
    }

    public <T> T as(GenericType<T> var1);

    public <T> Optional<T> asOptional(GenericType<T> var1);

    public boolean hasEntity();

    public boolean consumed();

    public ReadableEntity copy(Runnable var1);

    default public void consume() {
        if (this.consumed()) {
            return;
        }
        try (InputStream inputStream = this.inputStream();){
            byte[] buffer = new byte[2048];
            while (inputStream.read(buffer) > 0) {
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

