/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.grpc.core;

import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import io.helidon.grpc.core.MarshallerSupplier;
import java.lang.reflect.Method;

class ProtoMarshallerSupplier
implements MarshallerSupplier {
    private ProtoMarshallerSupplier() {
    }

    static ProtoMarshallerSupplier create() {
        return new ProtoMarshallerSupplier();
    }

    @Override
    public <T> MethodDescriptor.Marshaller<T> get(Class<T> clazz) {
        try {
            Method getDefaultInstance = clazz.getDeclaredMethod("getDefaultInstance", new Class[0]);
            Message instance = (Message)getDefaultInstance.invoke(clazz, new Object[0]);
            return ProtoUtils.marshaller((Message)instance);
        }
        catch (Exception e) {
            String msg = String.format("Attempting to use class %s, which is not a valid Protocol buffer message, with a default marshaller", clazz.getName());
            throw new IllegalArgumentException(msg);
        }
    }
}

