/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.datatypes;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Objects;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.hyperledger.besu.datatypes.Hash;

public class VersionedHash {
    Bytes32 hashish;
    public static final byte SHA256_VERSION_ID = 1;
    public static final VersionedHash DEFAULT_VERSIONED_HASH = new VersionedHash(1, Hash.ZERO);

    public VersionedHash(byte versionId, Hash hash) {
        if (versionId != 1) {
            throw new IllegalArgumentException("Only supported hash version is 0x01, sha256 hash.");
        }
        this.hashish = Bytes32.wrap((Bytes)Bytes.concatenate((Bytes[])new Bytes[]{Bytes.of((byte[])new byte[]{1}), hash.slice(1, hash.size() - 1)}));
    }

    public VersionedHash(Bytes32 typedHash) {
        byte versionId = typedHash.get(0);
        if (versionId != 1) {
            throw new IllegalArgumentException("Only supported hash version is 0x01, sha256 hash.");
        }
        this.hashish = typedHash;
    }

    @JsonCreator
    public static VersionedHash fromHexString(String str) {
        return new VersionedHash(Bytes32.fromHexString((CharSequence)str));
    }

    public Bytes32 toBytes() {
        return this.hashish;
    }

    public byte getVersionId() {
        return this.hashish.get(0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionedHash that = (VersionedHash)o;
        return this.getVersionId() == that.getVersionId() && Objects.equals(this.toBytes(), that.toBytes());
    }

    public int hashCode() {
        return Objects.hash(this.getVersionId(), this.hashish);
    }

    @JsonValue
    public String toString() {
        return this.toBytes().toHexString();
    }
}

