/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.config.converter;

import com.hedera.node.config.types.KeyValuePair;
import com.swirlds.config.api.converter.ConfigConverter;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.regex.Pattern;

public class KeyValuePairConverter
implements ConfigConverter<KeyValuePair> {
    private static final String PATTERN = Pattern.quote("=");

    public KeyValuePair convert(@NonNull String value) throws IllegalArgumentException, NullPointerException {
        Objects.requireNonNull(value, "Parameter 'value' cannot be null");
        String[] split = value.split(PATTERN, 2);
        if (split.length == 1) {
            throw new IllegalArgumentException("Invalid key value pair: " + value);
        }
        String key = split[0];
        String val = split[1];
        return new KeyValuePair(key, val);
    }
}

