/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.config.data;

import com.swirlds.config.api.ConfigData;

@ConfigData(value="grpc")
public record GrpcConfig(int port, int tlsPort, boolean nodeOperatorPortEnabled, int nodeOperatorPort, int workflowsPort, int workflowsTlsPort, int maxMessageSize, int maxResponseSize, int noopMarshallerMaxMessageSize) {
    public GrpcConfig(int port, int tlsPort, boolean nodeOperatorPortEnabled, int nodeOperatorPort, int workflowsPort, int workflowsTlsPort, int maxMessageSize, int maxResponseSize, int noopMarshallerMaxMessageSize) {
        this.validateFieldRange(port, 0, 65535, "port");
        this.validateFieldRange(tlsPort, 0, 65535, "tlsPort");
        this.validateFieldRange(workflowsPort, 0, 65535, "workflowsPort");
        this.validateFieldRange(workflowsTlsPort, 0, 65535, "workflowsTlsPort");
        this.validateFieldRange(maxMessageSize, 0, 0x400000, "maxMessageSize");
        this.validateFieldRange(maxResponseSize, 0, 0x400000, "maxResponseSize");
        this.validateFieldRange(noopMarshallerMaxMessageSize, 0, 0x400000, "noopMarshallerMaxMessageSize");
        this.validateUniquePorts(port, tlsPort);
        this.validateUniqueWorkflowsPorts(workflowsPort, workflowsTlsPort);
        this.port = port;
        this.tlsPort = tlsPort;
        this.nodeOperatorPortEnabled = nodeOperatorPortEnabled;
        this.nodeOperatorPort = nodeOperatorPort;
        this.workflowsPort = workflowsPort;
        this.workflowsTlsPort = workflowsTlsPort;
        this.maxMessageSize = maxMessageSize;
        this.maxResponseSize = maxResponseSize;
        this.noopMarshallerMaxMessageSize = noopMarshallerMaxMessageSize;
    }

    private void validateFieldRange(int value, int minValue, int maxValue, String fieldName) {
        if (value < minValue || value > maxValue) {
            throw new IllegalArgumentException("grpc." + fieldName + " must be between " + minValue + " and " + maxValue);
        }
    }

    private void validateUniquePorts(int port1, int port2) {
        if (port1 == port2 && port1 != 0) {
            throw new IllegalArgumentException("grpc.port and grpc.tlsPort must be different");
        }
    }

    private void validateUniqueWorkflowsPorts(int port1, int port2) {
        if (port1 == port2 && port1 != 0) {
            throw new IllegalArgumentException("grpc.workflowsPort and grpc.workflowsTlsPort must be different");
        }
        if (this.nodeOperatorPortEnabled && (this.nodeOperatorPort == this.port || this.nodeOperatorPort == this.tlsPort)) {
            throw new IllegalArgumentException("grpc.nodeOperatorPort must be different from grpc.port and grpc.tlsPort");
        }
    }
}

