/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.config.types;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class PermissionedAccountsRange {
    private static final Pattern DEGENERATE = Pattern.compile("\\d+");
    private static final Pattern NON_DEGENERATE = Pattern.compile("(\\d+)-(\\d+)");
    private static final Pattern NON_DEGENERATE_WILDCARD = Pattern.compile("(\\d+)-[*]");
    final Long from;
    final Long inclusiveTo;

    public static PermissionedAccountsRange from(String description) {
        Matcher nonDegenWildMatch;
        if (StringUtils.isEmpty((CharSequence)description)) {
            return null;
        }
        Matcher degenMatch = DEGENERATE.matcher(description);
        if (degenMatch.matches()) {
            return new PermissionedAccountsRange(Long.valueOf(description));
        }
        Matcher nonDegenMatch = NON_DEGENERATE.matcher(description);
        if (nonDegenMatch.matches()) {
            Long supposedFrom = Long.valueOf(nonDegenMatch.group(1));
            Long supposedTo = Long.valueOf(nonDegenMatch.group(2));
            if (supposedFrom < supposedTo) {
                return new PermissionedAccountsRange(supposedFrom, supposedTo);
            }
            if (supposedFrom.equals(supposedTo)) {
                return new PermissionedAccountsRange(supposedFrom);
            }
        }
        if ((nonDegenWildMatch = NON_DEGENERATE_WILDCARD.matcher(description)).matches()) {
            return new PermissionedAccountsRange(Long.valueOf(nonDegenWildMatch.group(1)), Long.MAX_VALUE);
        }
        return null;
    }

    public PermissionedAccountsRange(Long from, Long inclusiveTo) {
        this.from = from;
        this.inclusiveTo = inclusiveTo;
    }

    public PermissionedAccountsRange(Long from) {
        this.from = from;
        this.inclusiveTo = null;
    }

    public Long from() {
        return this.from;
    }

    public Long inclusiveTo() {
        return this.inclusiveTo;
    }

    public boolean contains(long num) {
        if (this.inclusiveTo == null) {
            return num == this.from;
        }
        return this.from <= num && num <= this.inclusiveTo;
    }

    public String toString() {
        return this.from + "-" + this.inclusiveTo;
    }
}

