/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.util;

import com.hedera.node.app.blocks.impl.streaming.BlockNodeConnection;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public class LoggingUtilities {
    private LoggingUtilities() {
        throw new IllegalStateException("Utility class");
    }

    public static String threadInfo() {
        Thread currentThread = Thread.currentThread();
        return String.format("[Thread:%s/ID:%d]", currentThread.getName(), currentThread.threadId());
    }

    public static void logWithContext(Logger logger, Level level, BlockNodeConnection connection, String message, Object ... args) {
        if (logger.isEnabled(level)) {
            message = LoggingUtilities.formatLogMessage(message, connection);
            logger.atLevel(level).log(message, args);
        }
    }

    public static void logWithContext(Logger logger, Level level, String message, Object ... args) {
        if (logger.isEnabled(level)) {
            message = String.format("%s %s", LoggingUtilities.threadInfo(), message);
            logger.atLevel(level).log(message, args);
        }
    }

    public static String formatLogMessage(String message, BlockNodeConnection connection) {
        return String.format("%s %s %s", LoggingUtilities.threadInfo(), connection, message);
    }
}

