/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.configurable;

import io.helidon.builder.api.RuntimeType;
import io.helidon.common.config.Config;
import io.helidon.common.config.ConfigException;
import io.helidon.common.configurable.ResourceConfig;
import io.helidon.common.configurable.ResourceImpl;
import io.helidon.common.configurable.ResourceUtil;
import java.io.InputStream;
import java.net.Proxy;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Base64;
import java.util.Objects;
import java.util.function.Consumer;

@RuntimeType.PrototypedBy(value=ResourceConfig.class)
public interface Resource
extends RuntimeType.Api<ResourceConfig> {
    public static Resource create(URI uri) {
        return ResourceUtil.from(ResourceUtil.toIs(uri), uri.toString(), Source.URL);
    }

    public static Resource create(URI uri, Proxy proxy) {
        return ResourceUtil.from(ResourceUtil.toIs(uri, proxy), uri.toString(), Source.URL);
    }

    public static Resource create(String resourcePath) {
        return ResourceUtil.from(ResourceUtil.toIs(resourcePath), resourcePath, Source.CLASSPATH);
    }

    public static Resource create(Path fsPath) {
        return ResourceUtil.from(ResourceUtil.toIs(fsPath), fsPath.toAbsolutePath().toString(), Source.FILE);
    }

    public static Resource create(String description, byte[] bytes) {
        Objects.requireNonNull(bytes, "Resource bytes must not be null");
        return new ResourceImpl(((ResourceConfig.Builder)ResourceConfig.builder().description(description)).buildPrototype(), Source.BINARY_CONTENT, bytes);
    }

    public static Resource create(String description, String string) {
        Objects.requireNonNull(string, "Resource content must not be null");
        return new ResourceImpl(((ResourceConfig.Builder)((ResourceConfig.Builder)ResourceConfig.builder().contentPlain(string)).description(description)).buildPrototype(), Source.CONTENT, string.getBytes(StandardCharsets.UTF_8));
    }

    public static Resource create(String description, InputStream inputStream) {
        return ResourceUtil.from(inputStream, description, Source.UNKNOWN);
    }

    public static Resource create(ResourceConfig config) {
        if (config.path().isPresent()) {
            return Resource.create(config.path().get());
        }
        if (config.resourcePath().isPresent()) {
            return Resource.create(config.resourcePath().get());
        }
        if (config.uri().isPresent()) {
            if (config.useProxy() && config.proxy().isPresent()) {
                return Resource.create(config.uri().get(), config.proxy().get());
            }
            return Resource.create(config.uri().get());
        }
        if (config.contentPlain().isPresent()) {
            return Resource.create(config.description(), config.contentPlain().get());
        }
        if (config.content().isPresent()) {
            String b64Content = config.content().get();
            byte[] contentBytes = Base64.getDecoder().decode(b64Content);
            return Resource.create(config.description(), contentBytes);
        }
        throw new ConfigException("Invalid resource configuration, one of(path,resource-path,url,content-plain,content) must be configured");
    }

    public static Resource create(Consumer<ResourceConfig.Builder> consumer) {
        ResourceConfig.Builder builder = ResourceConfig.builder();
        consumer.accept(builder);
        return builder.build();
    }

    public static ResourceConfig.Builder builder() {
        return ResourceConfig.builder();
    }

    public static Resource create(Config config) {
        return (Resource)ResourceConfig.create(config).build();
    }

    public InputStream stream();

    public byte[] bytes();

    public String string();

    public String string(Charset var1);

    public Source sourceType();

    public String location();

    public void cacheBytes();

    public static enum Source {
        FILE,
        CLASSPATH,
        URL,
        CONTENT,
        BINARY_CONTENT,
        UNKNOWN;

    }
}

