/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.media.type;

import io.helidon.common.media.type.MediaType;
import io.helidon.common.media.type.MediaTypes;
import io.helidon.common.media.type.spi.MediaTypeDetector;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;

class BuiltInsDetector
implements MediaTypeDetector {
    private static final System.Logger LOGGER = System.getLogger(BuiltInsDetector.class.getName());
    private static final Map<String, MediaType> MAPPINGS = new HashMap<String, MediaType>();

    BuiltInsDetector() {
    }

    @Override
    public Optional<MediaType> detectExtensionType(String fileSuffix) {
        return Optional.ofNullable(MAPPINGS.get(fileSuffix));
    }

    static {
        try (InputStream builtIns = MediaTypes.class.getResourceAsStream("default-media-types.properties");){
            if (null != builtIns) {
                Properties properties = new Properties();
                properties.load(builtIns);
                for (String name : properties.stringPropertyNames()) {
                    MAPPINGS.put(name, MediaTypes.create(properties.getProperty(name)));
                }
            } else {
                LOGGER.log(System.Logger.Level.ERROR, "Failed to find default media type mapping resource");
            }
        }
        catch (IOException e) {
            LOGGER.log(System.Logger.Level.ERROR, "Failed to load default media types mapping", (Throwable)e);
        }
    }
}

