/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.media.type;

import io.helidon.common.HelidonServiceLoader;
import io.helidon.common.media.type.BuiltInsDetector;
import io.helidon.common.media.type.CustomDetector;
import io.helidon.common.media.type.MediaType;
import io.helidon.common.media.type.spi.MediaTypeDetector;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;

final class Detectors {
    private static final List<MediaTypeDetector> DETECTORS;
    private static final ConcurrentHashMap<String, Optional<MediaType>> CACHE;

    private Detectors() {
    }

    static Optional<MediaType> detectExtensionType(String fileSuffix) {
        return CACHE.computeIfAbsent(fileSuffix, it -> DETECTORS.stream().map(mtd -> mtd.detectExtensionType(fileSuffix)).flatMap(Optional::stream).findFirst());
    }

    static Optional<MediaType> detectType(String fileName) {
        return DETECTORS.stream().map(mtd -> mtd.detectType(fileName)).flatMap(Optional::stream).findFirst();
    }

    static Optional<MediaType> detectType(Path file) {
        return DETECTORS.stream().map(mtd -> mtd.detectType(file)).flatMap(Optional::stream).findFirst();
    }

    static Optional<MediaType> detectType(URI uri) {
        return DETECTORS.stream().map(mtd -> mtd.detectType(uri)).flatMap(Optional::stream).findFirst();
    }

    static Optional<MediaType> detectType(URL url) {
        return DETECTORS.stream().map(mtd -> mtd.detectType(url)).flatMap(Optional::stream).findFirst();
    }

    static {
        CACHE = new ConcurrentHashMap();
        DETECTORS = HelidonServiceLoader.builder(ServiceLoader.load(MediaTypeDetector.class)).addService((Object)new BuiltInsDetector(), 0.0).addService((Object)new CustomDetector(), 1.0).build().asList();
    }
}

