/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.util.impl.cache;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.util.impl.cache.TransactionParser;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.config.api.Configuration;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.concurrent.TimeUnit;

public class InnerTxnCache {
    private static final int INNER_TXN_CACHE_TIMEOUT = 15;
    private final LoadingCache<Bytes, TransactionBody> transactionsCache = Caffeine.newBuilder().expireAfterWrite(15L, TimeUnit.SECONDS).build(transactionBytes -> transactionParser.parse((Bytes)transactionBytes, configuration));

    public InnerTxnCache(@NonNull TransactionParser transactionParser, @NonNull Configuration configuration) {
    }

    public TransactionBody computeIfAbsent(@NonNull Bytes bytes) throws PreCheckException {
        try {
            return (TransactionBody)this.transactionsCache.get((Object)bytes);
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause instanceof PreCheckException) {
                throw (PreCheckException)cause;
            }
            throw e;
        }
    }

    public TransactionBody computeIfAbsentUnchecked(@NonNull Bytes bytes) {
        return (TransactionBody)this.transactionsCache.get((Object)bytes);
    }
}

