/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl;

import com.hedera.hapi.node.state.common.EntityNumber;
import com.hedera.hapi.node.state.token.StakingNodeInfo;
import com.hedera.node.app.hapi.utils.EntityType;
import com.hedera.node.app.service.token.ReadableStakingInfoStore;
import com.hedera.node.app.service.token.impl.schemas.V0490TokenSchema;
import com.hedera.node.app.spi.ids.ReadableEntityCounters;
import com.swirlds.state.spi.ReadableKVState;
import com.swirlds.state.spi.ReadableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReadableStakingInfoStoreImpl
implements ReadableStakingInfoStore {
    private static final Logger log = LogManager.getLogger(ReadableStakingInfoStoreImpl.class);
    private final ReadableKVState<EntityNumber, StakingNodeInfo> stakingInfoState;
    private final ReadableEntityCounters entityCounters;

    public ReadableStakingInfoStoreImpl(@NonNull ReadableStates states, ReadableEntityCounters entityCounters) {
        this.entityCounters = Objects.requireNonNull(entityCounters);
        this.stakingInfoState = states.get(V0490TokenSchema.STAKING_INFOS_STATE_ID);
    }

    @Nullable
    public StakingNodeInfo get(long nodeId) {
        return (StakingNodeInfo)this.stakingInfoState.get((Object)new EntityNumber(nodeId));
    }

    @NonNull
    public Set<Long> getAll() {
        long numStakingInfo = this.entityCounters.getCounterFor(EntityType.STAKING_INFO);
        if (numStakingInfo == 0L) {
            return Collections.emptySet();
        }
        HashSet<Long> nodeIds = new HashSet<Long>();
        int i = 0;
        while ((long)i < numStakingInfo) {
            EntityNumber nodeId = new EntityNumber((long)i);
            if (this.stakingInfoState.contains((Object)nodeId)) {
                nodeIds.add(nodeId.number());
            } else {
                log.warn("Staking info for node {} not found in state", (Object)nodeId.number());
            }
            ++i;
        }
        return nodeIds;
    }
}

