/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl;

import com.hedera.hapi.node.base.NftID;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.state.token.Nft;
import com.hedera.node.app.hapi.utils.EntityType;
import com.hedera.node.app.service.token.impl.ReadableNftStoreImpl;
import com.hedera.node.app.service.token.impl.schemas.V0490TokenSchema;
import com.hedera.node.app.spi.ids.ReadableEntityCounters;
import com.hedera.node.app.spi.ids.WritableEntityCounters;
import com.swirlds.state.spi.ReadableStates;
import com.swirlds.state.spi.WritableKVState;
import com.swirlds.state.spi.WritableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.Set;

public class WritableNftStore
extends ReadableNftStoreImpl {
    private final WritableKVState<NftID, Nft> nftState;
    private final WritableEntityCounters entityCounters;

    public WritableNftStore(@NonNull WritableStates states, @NonNull WritableEntityCounters entityCounters) {
        super((ReadableStates)states, (ReadableEntityCounters)entityCounters);
        this.nftState = states.get(V0490TokenSchema.NFTS_STATE_ID);
        this.entityCounters = entityCounters;
    }

    public void put(@NonNull Nft nft) {
        Objects.requireNonNull(nft);
        this.requireNotDefault(nft.nftId());
        this.nftState.put((Object)nft.nftId(), (Object)nft);
    }

    public void putAndIncrementCount(@NonNull Nft nft) {
        this.put(nft);
        this.entityCounters.incrementEntityTypeCount(EntityType.NFT);
    }

    @NonNull
    public Set<NftID> modifiedNfts() {
        return this.nftState.modifiedKeys();
    }

    public void remove(@NonNull NftID serialNum) {
        this.nftState.remove((Object)Objects.requireNonNull(serialNum));
        this.entityCounters.decrementEntityTypeCounter(EntityType.NFT);
    }

    public void remove(@NonNull TokenID tokenId, long serialNum) {
        NftID nftId = NftID.newBuilder().tokenId(tokenId).serialNumber(serialNum).build();
        this.requireNotDefault(nftId);
        this.remove(nftId);
    }

    @Nullable
    public Nft getOriginalValue(@NonNull NftID nftId) {
        Objects.requireNonNull(nftId);
        return (Nft)this.nftState.getOriginalValue((Object)nftId);
    }

    private void requireNotDefault(@NonNull NftID nftId) {
        if (nftId.equals((Object)NftID.DEFAULT)) {
            throw new IllegalArgumentException("Nft ID cannot be default");
        }
    }
}

