/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.handlers;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.NftID;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.SubType;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.state.token.Nft;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.hapi.node.token.CryptoDeleteAllowanceTransactionBody;
import com.hedera.hapi.node.token.NftRemoveAllowance;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.service.token.impl.WritableAccountStore;
import com.hedera.node.app.service.token.impl.WritableNftStore;
import com.hedera.node.app.service.token.impl.WritableTokenStore;
import com.hedera.node.app.service.token.impl.util.TokenHandlerHelper;
import com.hedera.node.app.service.token.impl.validators.AllowanceValidator;
import com.hedera.node.app.service.token.impl.validators.ApproveAllowanceValidator;
import com.hedera.node.app.service.token.impl.validators.DeleteAllowanceValidator;
import com.hedera.node.app.spi.fees.FeeContext;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.store.StoreFactory;
import com.hedera.node.app.spi.validation.ExpiryValidator;
import com.hedera.node.app.spi.validation.Validations;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.PreHandleContext;
import com.hedera.node.app.spi.workflows.PureChecksContext;
import com.hedera.node.app.spi.workflows.TransactionHandler;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class CryptoDeleteAllowanceHandler
implements TransactionHandler {
    private final DeleteAllowanceValidator deleteAllowanceValidator;

    @Inject
    public CryptoDeleteAllowanceHandler(@NonNull DeleteAllowanceValidator validator) {
        this.deleteAllowanceValidator = validator;
    }

    public void pureChecks(@NonNull PureChecksContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        TransactionBody txn = context.body();
        Objects.requireNonNull(txn);
        CryptoDeleteAllowanceTransactionBody op = txn.cryptoDeleteAllowanceOrThrow();
        List allowances = op.nftAllowances();
        PreCheckException.validateTruePreCheck((!allowances.isEmpty() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.EMPTY_ALLOWANCES);
        for (NftRemoveAllowance allowance : allowances) {
            Validations.mustExist((Object)allowance.tokenId(), (ResponseCodeEnum)ResponseCodeEnum.INVALID_TOKEN_ID);
            PreCheckException.validateTruePreCheck((!allowance.serialNumbers().isEmpty() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.EMPTY_ALLOWANCES);
        }
    }

    public void preHandle(@NonNull PreHandleContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        TransactionBody txn = context.body();
        CryptoDeleteAllowanceTransactionBody op = txn.cryptoDeleteAllowanceOrThrow();
        for (NftRemoveAllowance allowance : op.nftAllowances()) {
            if (!allowance.hasOwner()) continue;
            ReadableAccountStore store = (ReadableAccountStore)context.createStore(ReadableAccountStore.class);
            AccountID ownerId = allowance.ownerOrThrow();
            Account owner = store.getAccountById(ownerId);
            boolean approvedForAll = owner.approveForAllNftAllowances().stream().anyMatch(approveForAll -> approveForAll.tokenId().equals((Object)allowance.tokenId()) && approveForAll.spenderId().equals((Object)context.payer()));
            if (context.payer().equals((Object)ownerId) || approvedForAll) continue;
            context.requireKeyOrThrow(ownerId, ResponseCodeEnum.INVALID_ALLOWANCE_OWNER_ID);
        }
    }

    public void handle(@NonNull HandleContext context) throws HandleException {
        AccountID payer = context.payer();
        WritableAccountStore accountStore = (WritableAccountStore)context.storeFactory().writableStore(WritableAccountStore.class);
        Account payerAccount = TokenHandlerHelper.getIfUsable(payer, accountStore, context.expiryValidator(), ResponseCodeEnum.INVALID_PAYER_ACCOUNT_ID);
        this.validateSemantics(context, payerAccount, accountStore);
        this.deleteAllowance(context, payerAccount, accountStore);
    }

    private void deleteAllowance(@NonNull HandleContext context, @NonNull Account payer, @NonNull WritableAccountStore accountStore) throws HandleException {
        Objects.requireNonNull(context);
        Objects.requireNonNull(payer);
        Objects.requireNonNull(accountStore);
        CryptoDeleteAllowanceTransactionBody op = context.body().cryptoDeleteAllowanceOrThrow();
        List nftAllowances = op.nftAllowances();
        StoreFactory storeFactory = context.storeFactory();
        WritableNftStore nftStore = (WritableNftStore)storeFactory.writableStore(WritableNftStore.class);
        WritableTokenStore tokenStore = (WritableTokenStore)storeFactory.writableStore(WritableTokenStore.class);
        this.deleteNftSerials(nftAllowances, payer, accountStore, tokenStore, nftStore, context.expiryValidator());
    }

    private void deleteNftSerials(List<NftRemoveAllowance> nftAllowances, Account payerAccount, WritableAccountStore accountStore, WritableTokenStore tokenStore, WritableNftStore nftStore, @NonNull ExpiryValidator expiryValidator) throws HandleException {
        if (nftAllowances.isEmpty()) {
            return;
        }
        for (NftRemoveAllowance allowance : nftAllowances) {
            List serialNums = allowance.serialNumbers();
            TokenID tokenId = allowance.tokenIdOrElse(TokenID.DEFAULT);
            Account owner = ApproveAllowanceValidator.getEffectiveOwner(allowance.owner(), payerAccount, accountStore, expiryValidator);
            Token token = tokenStore.get(tokenId);
            for (Long serial : serialNums) {
                NftID nftId = NftID.newBuilder().serialNumber(serial.longValue()).tokenId(tokenId).build();
                Nft nft = TokenHandlerHelper.getIfUsable(nftId, nftStore);
                AccountID accountOwner = owner.accountId();
                HandleException.validateTrue((boolean)AllowanceValidator.isValidOwner(nft, accountOwner, token), (ResponseCodeEnum)ResponseCodeEnum.SENDER_DOES_NOT_OWN_NFT_SERIAL_NO);
                nftStore.put(nft.copyBuilder().spenderId((AccountID)null).build());
            }
        }
    }

    private void validateSemantics(@NonNull HandleContext context, Account payerAccount, ReadableAccountStore accountStore) {
        Objects.requireNonNull(context);
        Objects.requireNonNull(payerAccount);
        Objects.requireNonNull(accountStore);
        CryptoDeleteAllowanceTransactionBody op = context.body().cryptoDeleteAllowanceOrThrow();
        List nftAllowances = op.nftAllowances();
        this.deleteAllowanceValidator.validate(context, nftAllowances, payerAccount, accountStore);
    }

    @NonNull
    public Fees calculateFees(@NonNull FeeContext feeContext) {
        TransactionBody body = feeContext.body();
        CryptoDeleteAllowanceTransactionBody op = body.cryptoDeleteAllowanceOrThrow();
        return feeContext.feeCalculatorFactory().feeCalculator(SubType.DEFAULT).addBytesPerTransaction((long)op.nftAllowances().size() * 48L + (long)this.countNftDeleteSerials(op.nftAllowances()) * 8L).calculate();
    }

    private int countNftDeleteSerials(List<NftRemoveAllowance> nftAllowancesList) {
        int totalSerials = 0;
        for (NftRemoveAllowance allowance : nftAllowancesList) {
            totalSerials += allowance.serialNumbers().size();
        }
        return totalSerials;
    }
}

