/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.validators;

import com.hedera.hapi.node.base.AccountAmount;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.NftTransfer;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.TokenTransferList;
import com.hedera.hapi.node.base.TokenType;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.state.token.Nft;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.hapi.node.state.token.TokenRelation;
import com.hedera.hapi.node.token.TokenAirdropTransactionBody;
import com.hedera.hapi.node.transaction.CustomFee;
import com.hedera.node.app.service.token.ReadableNftStore;
import com.hedera.node.app.service.token.ReadableTokenRelationStore;
import com.hedera.node.app.service.token.ReadableTokenStore;
import com.hedera.node.app.service.token.impl.WritableAccountStore;
import com.hedera.node.app.service.token.impl.handlers.transfer.customfees.CustomFeeExemptions;
import com.hedera.node.app.service.token.impl.util.TokenHandlerHelper;
import com.hedera.node.app.service.token.impl.validators.CryptoTransferValidator;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.config.data.LedgerConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class TokenAirdropValidator {
    @Inject
    public TokenAirdropValidator() {
    }

    public void pureChecks(@NonNull TokenAirdropTransactionBody op) throws PreCheckException {
        List tokenTransfers = op.tokenTransfers();
        PreCheckException.validateTruePreCheck((!tokenTransfers.isEmpty() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.EMPTY_TOKEN_TRANSFER_BODY);
        for (TokenTransferList tokenTransfer : tokenTransfers) {
            if (!tokenTransfer.nftTransfers().isEmpty()) {
                AccountID sender = ((NftTransfer)tokenTransfer.nftTransfers().stream().findFirst().get()).senderAccountID();
                PreCheckException.validateTruePreCheck((sender != null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_TRANSFER_ACCOUNT_ID);
                boolean allNftsHaveTheSameSender = tokenTransfer.nftTransfers().stream().allMatch(nftTransfer -> sender.equals((Object)nftTransfer.senderAccountID()));
                PreCheckException.validateTruePreCheck((boolean)allNftsHaveTheSameSender, (ResponseCodeEnum)ResponseCodeEnum.AIRDROP_CONTAINS_MULTIPLE_SENDERS_FOR_A_TOKEN);
                for (NftTransfer nftTransfer2 : tokenTransfer.nftTransfers()) {
                    PreCheckException.validateFalsePreCheck((nftTransfer2.hasPreTxSenderAllowanceHook() || nftTransfer2.hasPrePostTxSenderAllowanceHook() || nftTransfer2.hasPreTxReceiverAllowanceHook() || nftTransfer2.hasPrePostTxReceiverAllowanceHook() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.HOOKS_ARE_NOT_SUPPORTED_IN_AIRDROPS);
                }
            }
            if (tokenTransfer.transfers().isEmpty()) continue;
            List<AccountAmount> negativeTransfers = tokenTransfer.transfers().stream().filter(fungibleTransfer -> fungibleTransfer.amount() < 0L).toList();
            PreCheckException.validateTruePreCheck((negativeTransfers.size() == 1 ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.AIRDROP_CONTAINS_MULTIPLE_SENDERS_FOR_A_TOKEN);
            for (AccountAmount adjust : tokenTransfer.transfers()) {
                PreCheckException.validateFalsePreCheck((adjust.hasPreTxAllowanceHook() || adjust.hasPrePostTxAllowanceHook() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.HOOKS_ARE_NOT_SUPPORTED_IN_AIRDROPS);
            }
        }
        CryptoTransferValidator.validateTokenTransfers(op.tokenTransfers(), CryptoTransferValidator.AllowanceStrategy.ALLOWANCES_REJECTED);
    }

    public void validateSemantics(@NonNull HandleContext context, @NonNull TokenAirdropTransactionBody op, @NonNull WritableAccountStore accountStore, @NonNull ReadableTokenStore tokenStore, @NonNull ReadableTokenRelationStore tokenRelStore, @NonNull ReadableNftStore nftStore) {
        LedgerConfig ledgerConfig = (LedgerConfig)context.configuration().getConfigData(LedgerConfig.class);
        int totalFungibleTransfers = 0;
        int totalNftTransfers = 0;
        for (TokenTransferList xfers : op.tokenTransfers()) {
            Account senderAccount;
            AccountID senderId;
            TokenID tokenId = xfers.tokenOrThrow();
            Token token = TokenHandlerHelper.getIfUsable(tokenId, tokenStore);
            if (!xfers.transfers().isEmpty()) {
                HandleException.validateTrue((token.tokenType() == TokenType.FUNGIBLE_COMMON ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.ACCOUNT_AMOUNT_TRANSFERS_ONLY_ALLOWED_FOR_FUNGIBLE_COMMON);
                Optional<AccountAmount> senderAccountAmount = xfers.transfers().stream().filter(item -> item.amount() < 0L).findFirst();
                senderId = ((AccountAmount)senderAccountAmount.orElseThrow()).accountIDOrThrow();
                senderAccount = TokenHandlerHelper.getIfUsableForAliasedId(senderId, accountStore, context.expiryValidator(), ResponseCodeEnum.INVALID_ACCOUNT_ID);
                TokenAirdropValidator.validateFungibleTransfers(senderAccount, tokenId, (AccountAmount)senderAccountAmount.get(), tokenRelStore);
                HandleException.validateTrue(((totalFungibleTransfers += xfers.transfers().size()) <= ledgerConfig.tokenTransfersMaxLen() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.TOKEN_TRANSFER_LIST_SIZE_LIMIT_EXCEEDED);
            }
            if (xfers.nftTransfers().isEmpty()) continue;
            for (NftTransfer transfer : xfers.nftTransfers()) {
                AccountID receiver = transfer.receiverAccountID();
                for (CustomFee fee : token.customFees()) {
                    if (!fee.hasRoyaltyFee()) continue;
                    if (fee.royaltyFeeOrThrow().hasFallbackFee()) {
                        HandleException.validateTrue((boolean)TokenAirdropValidator.isExemptFromCustomFees(token, receiver, fee), (ResponseCodeEnum)ResponseCodeEnum.TOKEN_AIRDROP_WITH_FALLBACK_ROYALTY);
                        continue;
                    }
                    AccountID senderId2 = transfer.senderAccountIDOrThrow();
                    if (TokenAirdropValidator.isExemptFromCustomFees(token, senderId2, fee)) continue;
                    HandleException.validateFalse((boolean)this.senderIsCreditedFungibleValue(op, senderId2), (ResponseCodeEnum)ResponseCodeEnum.TOKEN_AIRDROP_WITH_FALLBACK_ROYALTY);
                }
            }
            Optional nftTransfer = xfers.nftTransfers().stream().findFirst();
            senderId = ((NftTransfer)nftTransfer.orElseThrow()).senderAccountIDOrThrow();
            senderAccount = accountStore.getAliasedAccountById(senderId);
            HandleException.validateTrue((senderAccount != null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_ACCOUNT_ID);
            this.validateNftTransfers(senderAccount, tokenId, xfers.nftTransfers(), tokenRelStore, tokenStore, nftStore);
            HandleException.validateTrue(((totalNftTransfers += xfers.nftTransfers().size()) <= ledgerConfig.nftTransfersMaxLen() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.BATCH_SIZE_LIMIT_EXCEEDED);
        }
    }

    private boolean senderIsCreditedFungibleValue(@NonNull TokenAirdropTransactionBody op, @NonNull AccountID senderId) {
        for (TokenTransferList tokenTransfers : op.tokenTransfers()) {
            for (AccountAmount adjustment : tokenTransfers.transfers()) {
                if (!adjustment.accountIDOrThrow().equals((Object)senderId) || adjustment.amount() <= 0L) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isExemptFromCustomFees(Token token, AccountID receiverId, CustomFee fee) {
        return CustomFeeExemptions.isPayerExempt(token, fee, receiverId);
    }

    public boolean tokenHasNoRoyaltyWithFallbackFee(TokenID tokenId, ReadableTokenStore tokenStore) {
        Token token = TokenHandlerHelper.getIfUsable(tokenId, tokenStore);
        if (token.tokenType().equals((Object)TokenType.NON_FUNGIBLE_UNIQUE)) {
            for (CustomFee fee : token.customFees()) {
                if (!fee.hasRoyaltyFee() || !Objects.requireNonNull(fee.royaltyFee()).hasFallbackFee()) continue;
                return false;
            }
        }
        return true;
    }

    private static void validateFungibleTransfers(Account senderAccount, TokenID tokenId, AccountAmount senderAmount, ReadableTokenRelationStore tokenRelStore) {
        TokenRelation tokenRel = TokenHandlerHelper.getIfUsable(senderAccount.accountIdOrThrow(), tokenId, tokenRelStore);
        HandleException.validateTrue((tokenRel.balance() >= Math.abs(senderAmount.amount()) ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INSUFFICIENT_TOKEN_BALANCE);
    }

    private void validateNftTransfers(@NonNull Account senderAccount, @NonNull TokenID tokenId, @NonNull List<NftTransfer> nftTransfers, @NonNull ReadableTokenRelationStore tokenRelStore, @NonNull ReadableTokenStore tokenStore, @NonNull ReadableNftStore nftStore) {
        TokenHandlerHelper.getIfUsable(senderAccount.accountIdOrThrow(), tokenId, tokenRelStore);
        Token token = tokenStore.get(tokenId);
        HandleException.validateTrue((token != null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_TOKEN_ID);
        for (NftTransfer nftTransfer : nftTransfers) {
            Nft nft = nftStore.get(tokenId, nftTransfer.serialNumber());
            HandleException.validateTrue((nft != null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_NFT_ID);
            if (nft.hasOwnerId()) {
                HandleException.validateTrue((nft.ownerId() != null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_NFT_ID);
                HandleException.validateTrue((boolean)nft.ownerId().equals((Object)senderAccount.accountId()), (ResponseCodeEnum)ResponseCodeEnum.SENDER_DOES_NOT_OWN_NFT_SERIAL_NO);
                continue;
            }
            AccountID treasuryId = token.treasuryAccountId();
            HandleException.validateTrue((treasuryId != null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_ACCOUNT_ID);
            HandleException.validateTrue((boolean)treasuryId.equals((Object)senderAccount.accountId()), (ResponseCodeEnum)ResponseCodeEnum.SENDER_DOES_NOT_OWN_NFT_SERIAL_NO);
        }
    }
}

