/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.socket;

import io.helidon.common.buffers.BufferData;
import io.helidon.common.buffers.DataWriter;
import io.helidon.common.socket.HelidonSocket;
import io.helidon.common.socket.SmartSocketWriter;
import io.helidon.common.socket.SocketWriterAsync;
import io.helidon.common.socket.SocketWriterDirect;
import java.util.concurrent.ExecutorService;

public abstract class SocketWriter
implements DataWriter {
    private final HelidonSocket socket;

    protected SocketWriter(HelidonSocket socket) {
        this.socket = socket;
    }

    public static SocketWriter create(ExecutorService executor, HelidonSocket socket, int writeQueueLength, boolean smartAsyncWrites) {
        if (writeQueueLength <= 1) {
            return new SocketWriterDirect(socket);
        }
        return smartAsyncWrites ? new SmartSocketWriter(executor, socket, writeQueueLength) : new SocketWriterAsync(executor, socket, writeQueueLength);
    }

    public static SocketWriter create(HelidonSocket socket) {
        return new SocketWriterDirect(socket);
    }

    public void writeNow(BufferData ... buffers) {
        BufferData composite = BufferData.create((BufferData[])buffers);
        this.writeNow(composite);
    }

    public void writeNow(BufferData buffer) {
        this.socket.write(buffer);
    }

    public void close() {
    }

    protected HelidonSocket socket() {
        return this.socket;
    }
}

