/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.consensus.impl.handlers;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.SubType;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.TopicID;
import com.hedera.hapi.node.base.TransactionID;
import com.hedera.hapi.node.consensus.ConsensusMessageChunkInfo;
import com.hedera.hapi.node.consensus.ConsensusSubmitMessageTransactionBody;
import com.hedera.hapi.node.state.consensus.Topic;
import com.hedera.hapi.node.token.CryptoTransferTransactionBody;
import com.hedera.hapi.node.transaction.AssessedCustomFee;
import com.hedera.hapi.node.transaction.CustomFeeLimit;
import com.hedera.hapi.node.transaction.FixedCustomFee;
import com.hedera.hapi.node.transaction.FixedFee;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.hapi.utils.CommonPbjConverters;
import com.hedera.node.app.service.consensus.ReadableTopicStore;
import com.hedera.node.app.service.consensus.impl.WritableTopicStore;
import com.hedera.node.app.service.consensus.impl.handlers.customfee.ConsensusCustomFeeAssessor;
import com.hedera.node.app.service.consensus.impl.records.ConsensusSubmitMessageStreamBuilder;
import com.hedera.node.app.service.token.ReadableTokenStore;
import com.hedera.node.app.service.token.records.CryptoTransferStreamBuilder;
import com.hedera.node.app.spi.fees.FeeCalculator;
import com.hedera.node.app.spi.fees.FeeCalculatorFactory;
import com.hedera.node.app.spi.fees.FeeContext;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.key.KeyVerifier;
import com.hedera.node.app.spi.signatures.VerificationAssistant;
import com.hedera.node.app.spi.validation.Validations;
import com.hedera.node.app.spi.workflows.DispatchOptions;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.PreHandleContext;
import com.hedera.node.app.spi.workflows.PureChecksContext;
import com.hedera.node.app.spi.workflows.TransactionHandler;
import com.hedera.node.app.spi.workflows.record.StreamBuilder;
import com.hedera.node.config.data.ConsensusConfig;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ConsensusSubmitMessageHandler
implements TransactionHandler {
    private static final int LARGE_STEP_BYTES = 512;
    private static final int UNITS_PER_LARGE_STEP = 10;
    private static final int SMALL_STEP_BYTES = 50;
    public static final long RUNNING_HASH_VERSION = 3L;
    private final ConsensusCustomFeeAssessor customFeeAssessor;

    @Inject
    public ConsensusSubmitMessageHandler(@NonNull ConsensusCustomFeeAssessor customFeeAssessor) {
        this.customFeeAssessor = Objects.requireNonNull(customFeeAssessor);
    }

    public void pureChecks(@NonNull PureChecksContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        TransactionBody txn = context.body();
        ConsensusSubmitMessageTransactionBody op = txn.consensusSubmitMessageOrThrow();
        this.validateDuplicationFeeLimits(txn.maxCustomFees());
        PreCheckException.validateTruePreCheck((boolean)op.hasTopicID(), (ResponseCodeEnum)ResponseCodeEnum.INVALID_TOPIC_ID);
        PreCheckException.validateFalsePreCheck((op.message().length() == 0L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_TOPIC_MESSAGE);
    }

    public void preHandle(@NonNull PreHandleContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        ConsensusSubmitMessageTransactionBody op = context.body().consensusSubmitMessageOrThrow();
        ReadableTopicStore topicStore = (ReadableTopicStore)context.createStore(ReadableTopicStore.class);
        Topic topic = topicStore.getTopic(op.topicIDOrElse(TopicID.DEFAULT));
        Validations.mustExist((Object)topic, (ResponseCodeEnum)ResponseCodeEnum.INVALID_TOPIC_ID);
        PreCheckException.validateFalsePreCheck((boolean)topic.deleted(), (ResponseCodeEnum)ResponseCodeEnum.INVALID_TOPIC_ID);
        if (topic.hasSubmitKey()) {
            context.requireKeyOrThrow(topic.submitKeyOrThrow(), ResponseCodeEnum.INVALID_SUBMIT_KEY);
        }
    }

    public void handle(@NonNull HandleContext handleContext) {
        Objects.requireNonNull(handleContext);
        TransactionBody txn = handleContext.body();
        ConsensusSubmitMessageTransactionBody op = txn.consensusSubmitMessageOrThrow();
        WritableTopicStore topicStore = (WritableTopicStore)handleContext.storeFactory().writableStore(WritableTopicStore.class);
        Topic topic = topicStore.get(op.topicIDOrElse(TopicID.DEFAULT));
        ConsensusConfig config = (ConsensusConfig)handleContext.configuration().getConfigData(ConsensusConfig.class);
        this.validateTransaction(txn, config, topic);
        if (!topic.customFees().isEmpty() && !this.isFeeExempted(topic.feeExemptKeyList(), handleContext.keyVerifier())) {
            List<FixedCustomFee> feesToBeCharged = this.extractFeesToBeCharged(topic.customFees(), handleContext);
            if (!txn.maxCustomFees().isEmpty()) {
                this.validateFeeLimits(handleContext.payer(), feesToBeCharged, txn.maxCustomFees());
            }
            this.chargeCustomFees(feesToBeCharged, handleContext);
        }
        try {
            Topic updatedTopic = this.updateRunningHashAndSequenceNumber(txn, topic, handleContext.consensusNow());
            topicStore.put(updatedTopic);
            ((ConsensusSubmitMessageStreamBuilder)handleContext.savepointStack().getBaseBuilder(ConsensusSubmitMessageStreamBuilder.class)).topicRunningHash(updatedTopic.runningHash()).topicSequenceNumber(updatedTopic.sequenceNumber()).topicRunningHashVersion(3L);
        }
        catch (IOException e) {
            throw new HandleException(ResponseCodeEnum.INVALID_TRANSACTION);
        }
    }

    private void validateTransaction(TransactionBody txn, ConsensusConfig config, Topic topic) {
        TransactionID txnId = txn.transactionID();
        AccountID payer = txn.transactionIDOrElse(TransactionID.DEFAULT).accountIDOrElse(AccountID.DEFAULT);
        ConsensusSubmitMessageTransactionBody op = txn.consensusSubmitMessageOrThrow();
        long msgLen = op.message().length();
        if (msgLen > (long)config.messageMaxBytesAllowed()) {
            throw new HandleException(ResponseCodeEnum.MESSAGE_SIZE_TOO_LARGE);
        }
        if (topic == null) {
            throw new HandleException(ResponseCodeEnum.INVALID_TOPIC_ID);
        }
        this.validateChunkInfo(txnId, payer, op);
    }

    private void validateChunkInfo(TransactionID txnId, AccountID payer, ConsensusSubmitMessageTransactionBody op) {
        if (op.hasChunkInfo()) {
            ConsensusMessageChunkInfo chunkInfo = op.chunkInfoOrThrow();
            if (1 > chunkInfo.number() || chunkInfo.number() > chunkInfo.total()) {
                throw new HandleException(ResponseCodeEnum.INVALID_CHUNK_NUMBER);
            }
            if (!chunkInfo.initialTransactionIDOrElse(TransactionID.DEFAULT).accountIDOrElse(AccountID.DEFAULT).equals((Object)payer)) {
                throw new HandleException(ResponseCodeEnum.INVALID_CHUNK_TRANSACTION_ID);
            }
            if (1 == chunkInfo.number() && !chunkInfo.initialTransactionIDOrElse(TransactionID.DEFAULT).equals((Object)txnId)) {
                throw new HandleException(ResponseCodeEnum.INVALID_CHUNK_TRANSACTION_ID);
            }
        }
    }

    public Topic updateRunningHashAndSequenceNumber(@NonNull TransactionBody txn, @NonNull Topic topic, @Nullable Instant consensusNow) throws IOException {
        Objects.requireNonNull(txn);
        Objects.requireNonNull(topic);
        ConsensusSubmitMessageTransactionBody submitMessage = txn.consensusSubmitMessageOrThrow();
        AccountID payer = txn.transactionIDOrElse(TransactionID.DEFAULT).accountIDOrElse(AccountID.DEFAULT);
        TopicID topicId = submitMessage.topicIDOrElse(TopicID.DEFAULT);
        byte[] message = CommonPbjConverters.asBytes((Bytes)submitMessage.message());
        Topic.Builder topicBuilder = topic.copyBuilder();
        Instant effectiveConsensusNow = consensusNow == null ? Instant.ofEpochSecond(0L) : consensusNow;
        long sequenceNumber = topic.sequenceNumber();
        Bytes runningHash = topic.runningHash();
        ByteArrayOutputStream boas = new ByteArrayOutputStream();
        try (ObjectOutputStream out = new ObjectOutputStream(boas);){
            out.writeObject(CommonPbjConverters.asBytes((Bytes)runningHash));
            out.writeLong(3L);
            out.writeLong(payer.shardNum());
            out.writeLong(payer.realmNum());
            out.writeLong(payer.accountNumOrElse(Long.valueOf(0L)));
            out.writeLong(topicId.shardNum());
            out.writeLong(topicId.realmNum());
            out.writeLong(topicId.topicNum());
            out.writeLong(effectiveConsensusNow.getEpochSecond());
            out.writeInt(effectiveConsensusNow.getNano());
            topicBuilder.sequenceNumber(++sequenceNumber);
            out.writeLong(sequenceNumber);
            out.writeObject(ConsensusSubmitMessageHandler.noThrowSha384HashOf(message));
            out.flush();
            runningHash = Bytes.wrap((byte[])ConsensusSubmitMessageHandler.noThrowSha384HashOf(boas.toByteArray()));
            topicBuilder.runningHash(runningHash);
        }
        return topicBuilder.build();
    }

    public static byte[] noThrowSha384HashOf(byte[] byteArray) {
        try {
            return MessageDigest.getInstance("SHA-384").digest(byteArray);
        }
        catch (NoSuchAlgorithmException fatal) {
            throw new IllegalStateException(fatal);
        }
    }

    private void chargeCustomFees(List<FixedCustomFee> feesToBeCharged, HandleContext handleContext) {
        Map<FixedCustomFee, CryptoTransferTransactionBody> syntheticBodies = this.customFeeAssessor.assessCustomFee(feesToBeCharged, handleContext.payer());
        ArrayList<AssessedCustomFee> assessedCustomFees = new ArrayList<AssessedCustomFee>();
        for (Map.Entry<FixedCustomFee, CryptoTransferTransactionBody> entry : syntheticBodies.entrySet()) {
            CryptoTransferTransactionBody syntheticBody = entry.getValue();
            TransactionBody cryptoTransferBody = TransactionBody.newBuilder().cryptoTransfer(syntheticBody).build();
            CryptoTransferStreamBuilder dispatchedStreamBuilder = (CryptoTransferStreamBuilder)handleContext.dispatch(DispatchOptions.stepDispatch((AccountID)handleContext.payer(), (TransactionBody)cryptoTransferBody, CryptoTransferStreamBuilder.class, (StreamBuilder.SignedTxCustomizer)StreamBuilder.SignedTxCustomizer.SUPPRESSING_SIGNED_TX_CUSTOMIZER, (HandleContext.DispatchMetadata)new HandleContext.DispatchMetadata(HandleContext.DispatchMetadata.Type.TRANSACTION_FIXED_FEE, (Object)entry.getKey())));
            HandleException.validateTrue((boolean)dispatchedStreamBuilder.status().equals((Object)ResponseCodeEnum.SUCCESS), (ResponseCodeEnum)dispatchedStreamBuilder.status());
            assessedCustomFees.addAll(dispatchedStreamBuilder.getAssessedCustomFees());
        }
        ((ConsensusSubmitMessageStreamBuilder)handleContext.savepointStack().getBaseBuilder(ConsensusSubmitMessageStreamBuilder.class)).assessedCustomFees(assessedCustomFees);
    }

    private boolean isFeeExempted(@NonNull List<Key> feeExemptKeyList, @NonNull KeyVerifier keyVerifier) {
        if (!feeExemptKeyList.isEmpty()) {
            List authorizingKeys = keyVerifier.authorizingSimpleKeys().stream().toList();
            VerificationAssistant callback = (k, ignore) -> ConsensusSubmitMessageHandler.simpleKeyVerifierFrom(authorizingKeys).test((Key)k);
            for (Key feeExemptKey : feeExemptKeyList) {
                if (!keyVerifier.verificationFor(feeExemptKey, callback).passed()) continue;
                return true;
            }
        }
        return false;
    }

    public static Predicate<Key> simpleKeyVerifierFrom(@NonNull List<Key> signatories) {
        HashSet cryptoSigs = new HashSet();
        signatories.forEach(k -> {
            switch ((Key.KeyOneOfType)k.key().kind()) {
                case ED25519: 
                case ECDSA_SECP256K1: {
                    cryptoSigs.add(k);
                    break;
                }
            }
        });
        return key -> switch ((Key.KeyOneOfType)key.key().kind()) {
            case Key.KeyOneOfType.ED25519, Key.KeyOneOfType.ECDSA_SECP256K1 -> cryptoSigs.contains(key);
            default -> false;
        };
    }

    private void validateFeeLimits(@NonNull AccountID payer, @NonNull List<FixedCustomFee> topicCustomFees, @NonNull List<CustomFeeLimit> allCustomFeeLimits) {
        HashMap<TokenID, Long> tokenFees = new HashMap<TokenID, Long>();
        AtomicReference<Long> hbarFee = new AtomicReference<Long>(0L);
        this.totalAmountToBeCharged(topicCustomFees, hbarFee, tokenFees);
        List payerLimits = allCustomFeeLimits.stream().filter(maxCustomFee -> payer.equals((Object)maxCustomFee.accountId())).map(CustomFeeLimit::fees).flatMap(Collection::stream).toList();
        tokenFees.forEach((token, feeAmount) -> {
            boolean isValid = payerLimits.stream().filter(maxCustomFee -> token.equals((Object)maxCustomFee.denominatingTokenId())).anyMatch(maxCustomFee -> {
                HandleException.validateTrue((maxCustomFee.amount() >= feeAmount ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.MAX_CUSTOM_FEE_LIMIT_EXCEEDED);
                return true;
            });
            HandleException.validateTrue((boolean)isValid, (ResponseCodeEnum)ResponseCodeEnum.NO_VALID_MAX_CUSTOM_FEE);
        });
        if (hbarFee.get() > 0L) {
            FixedFee payerHbarLimit = payerLimits.stream().filter(maxCustomFee -> !maxCustomFee.hasDenominatingTokenId()).findFirst().orElseThrow(() -> new HandleException(ResponseCodeEnum.NO_VALID_MAX_CUSTOM_FEE));
            HandleException.validateTrue((payerHbarLimit.amount() >= hbarFee.get() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.MAX_CUSTOM_FEE_LIMIT_EXCEEDED);
        }
    }

    private List<FixedCustomFee> extractFeesToBeCharged(@NonNull List<FixedCustomFee> topicCustomFees, @NonNull HandleContext context) {
        AccountID payer = context.payer();
        ReadableTokenStore tokenStore = (ReadableTokenStore)context.storeFactory().readableStore(ReadableTokenStore.class);
        return topicCustomFees.stream().filter(fee -> {
            FixedFee fixedFee = fee.fixedFeeOrThrow();
            if (payer.equals((Object)fee.feeCollectorAccountId())) {
                return false;
            }
            if (fixedFee.hasDenominatingTokenId()) {
                TokenID denomTokenId = fixedFee.denominatingTokenId();
                AccountID treasury = this.customFeeAssessor.getTokenTreasury(denomTokenId, tokenStore);
                return !payer.equals((Object)treasury);
            }
            return true;
        }).toList();
    }

    private void totalAmountToBeCharged(@NonNull List<FixedCustomFee> topicCustomFees, AtomicReference<Long> hbarFee, Map<TokenID, Long> tokenFees) {
        for (FixedCustomFee fee : topicCustomFees) {
            FixedFee fixedFee = fee.fixedFeeOrThrow();
            if (!fixedFee.hasDenominatingTokenId()) {
                hbarFee.updateAndGet(v -> v + fixedFee.amount());
                continue;
            }
            TokenID denomTokenId = fixedFee.denominatingTokenId();
            tokenFees.put(denomTokenId, tokenFees.getOrDefault(denomTokenId, 0L) + fixedFee.amount());
        }
    }

    private void validateDuplicationFeeLimits(@NonNull List<CustomFeeLimit> allCustomFeeLimits) throws PreCheckException {
        List<AccountID> accounts = allCustomFeeLimits.stream().map(CustomFeeLimit::accountId).toList();
        PreCheckException.validateTruePreCheck((accounts.size() == new HashSet<AccountID>(accounts).size() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.DUPLICATE_ACCOUNT_ID_IN_MAX_CUSTOM_FEE_LIST);
        for (CustomFeeLimit customFeeLimit : allCustomFeeLimits) {
            List<FixedFee> htsCustomFeeLimits = customFeeLimit.fees().stream().filter(FixedFee::hasDenominatingTokenId).toList();
            List<FixedFee> hbarCustomFeeLimits = customFeeLimit.fees().stream().filter(maxCustomFee -> !maxCustomFee.hasDenominatingTokenId()).toList();
            boolean htsLimitHasDuplicate = htsCustomFeeLimits.stream().map(FixedFee::denominatingTokenId).collect(Collectors.toSet()).size() != htsCustomFeeLimits.size();
            boolean hbarLimitsHasDuplicate = new HashSet<FixedFee>(hbarCustomFeeLimits).size() != hbarCustomFeeLimits.size();
            PreCheckException.validateTruePreCheck((!htsLimitHasDuplicate && !hbarLimitsHasDuplicate ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.DUPLICATE_DENOMINATION_IN_MAX_CUSTOM_FEE_LIST);
        }
    }

    @NonNull
    public Fees calculateFees(@NonNull FeeContext feeContext) {
        Objects.requireNonNull(feeContext);
        ConsensusSubmitMessageTransactionBody op = feeContext.body().consensusSubmitMessageOrThrow();
        FeeCalculatorFactory calculatorFactory = feeContext.feeCalculatorFactory();
        long msgSize = op.message().length();
        Topic topic = ((ReadableTopicStore)feeContext.readableStore(ReadableTopicStore.class)).getTopic(op.topicIDOrElse(TopicID.DEFAULT));
        if (topic != null && !topic.customFees().isEmpty()) {
            FeeCalculator calculator = calculatorFactory.feeCalculator(SubType.SUBMIT_MESSAGE_WITH_CUSTOM_FEES);
            calculator.resetUsage();
            long largePart = Math.max(1L, msgSize / 512L);
            long remainder = msgSize < 512L ? 0L : msgSize % 512L;
            long feeUnits = 50L + (largePart - 1L) * 10L + (remainder + 50L - 1L) / 50L;
            return calculator.addVerificationsPerTransaction((long)Math.max(0, feeContext.numTxnSignatures() - 1)).addBytesPerTransaction(feeUnits).calculate();
        }
        return calculatorFactory.feeCalculator(SubType.DEFAULT).addBytesPerTransaction(24L + msgSize).addNetworkRamByteSeconds(10080L).calculate();
    }
}

