/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics.api;

import io.helidon.common.config.Config;
import io.helidon.metrics.api.ComponentMetricsSettings;

class ComponentMetricsSettingsImpl
implements ComponentMetricsSettings {
    private final boolean isEnabled;

    private ComponentMetricsSettingsImpl(Builder builder) {
        this.isEnabled = builder.isEnabled;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    static class Builder
    implements ComponentMetricsSettings.Builder {
        private boolean isEnabled = true;

        Builder() {
        }

        @Override
        public ComponentMetricsSettings build() {
            return new ComponentMetricsSettingsImpl(this);
        }

        @Override
        public ComponentMetricsSettings.Builder enabled(boolean value) {
            this.isEnabled = value;
            return this;
        }

        @Override
        public ComponentMetricsSettings.Builder config(Config config) {
            config.get("enabled").asBoolean().ifPresent(this::enabled);
            return this;
        }
    }
}

