/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics.api;

import io.helidon.metrics.api.Clock;
import io.helidon.metrics.api.HistogramSupport;
import io.helidon.metrics.api.Meter;
import io.helidon.metrics.api.MeterRegistry;
import io.helidon.metrics.api.MetricsFactory;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public interface Timer
extends Meter,
HistogramSupport {
    public static Builder builder(String name) {
        return MetricsFactory.getInstance().timerBuilder(name);
    }

    public static Sample start() {
        return MetricsFactory.getInstance().timerStart();
    }

    public static Sample start(MeterRegistry registry) {
        return MetricsFactory.getInstance().timerStart(registry);
    }

    public static Sample start(Clock clock) {
        return MetricsFactory.getInstance().timerStart(clock);
    }

    public void record(long var1, TimeUnit var3);

    public void record(Duration var1);

    public <T> T record(Supplier<T> var1);

    public <T> T record(Callable<T> var1) throws Exception;

    public void record(Runnable var1);

    public Runnable wrap(Runnable var1);

    public <T> Callable<T> wrap(Callable<T> var1);

    public <T> Supplier<T> wrap(Supplier<T> var1);

    public long count();

    public double totalTime(TimeUnit var1);

    public double mean(TimeUnit var1);

    public double max(TimeUnit var1);

    public static interface Builder
    extends Meter.Builder<Builder, Timer> {
        public Builder percentiles(double ... var1);

        public Builder buckets(Duration ... var1);

        public Builder minimumExpectedValue(Duration var1);

        public Builder maximumExpectedValue(Duration var1);

        public Builder publishPercentileHistogram(boolean var1);

        public Iterable<Double> percentiles();

        public Iterable<Duration> buckets();

        public Optional<Duration> minimumExpectedValue();

        public Optional<Duration> maximumExpectedValue();

        public Optional<Boolean> publishPercentileHistogram();
    }

    public static interface Sample {
        public long stop(Timer var1);
    }
}

