/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.pbj.grpc.helidon;

import com.hedera.pbj.grpc.helidon.DeadlineDetector;
import com.hedera.pbj.grpc.helidon.PbjMethodRoute;
import com.hedera.pbj.grpc.helidon.PbjProtocolHandler;
import com.hedera.pbj.grpc.helidon.PbjRouting;
import com.hedera.pbj.grpc.helidon.RouteNotFoundHandler;
import com.hedera.pbj.grpc.helidon.config.PbjConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.helidon.http.HttpPrologue;
import io.helidon.http.Method;
import io.helidon.http.http2.Http2Headers;
import io.helidon.http.http2.Http2Settings;
import io.helidon.http.http2.Http2StreamState;
import io.helidon.http.http2.Http2StreamWriter;
import io.helidon.http.http2.StreamFlowControl;
import io.helidon.metrics.api.Counter;
import io.helidon.metrics.api.Meter;
import io.helidon.metrics.api.MeterRegistry;
import io.helidon.metrics.api.Metrics;
import io.helidon.webserver.ConnectionContext;
import io.helidon.webserver.Router;
import io.helidon.webserver.Routing;
import io.helidon.webserver.http2.spi.Http2SubProtocolSelector;
import io.helidon.webserver.http2.spi.SubProtocolResult;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

class PbjProtocolSelector
implements Http2SubProtocolSelector {
    private static final PbjRouting EMPTY = PbjRouting.builder().build();
    private final PbjConfig config;
    private final DeadlineDetector deadlineDetector;
    private final ScheduledExecutorService deadlineExecutorService = Executors.newSingleThreadScheduledExecutor();
    private final Counter requestCounter;
    private final Counter failedRequestCounter;

    PbjProtocolSelector(@NonNull PbjConfig config) {
        this.config = Objects.requireNonNull(config);
        this.deadlineDetector = (deadline, onDeadlineExceeded) -> this.deadlineExecutorService.schedule(onDeadlineExceeded, deadline, TimeUnit.NANOSECONDS);
        MeterRegistry metricRegistry = Metrics.globalRegistry();
        this.requestCounter = (Counter)metricRegistry.getOrCreate((Meter.Builder)((Counter.Builder)((Counter.Builder)Counter.builder((String)"pbj.grpc.requests").scope("vendor")).description("The number of gRPC requests")));
        this.failedRequestCounter = (Counter)metricRegistry.getOrCreate((Meter.Builder)((Counter.Builder)((Counter.Builder)Counter.builder((String)"pbj.grpc.request.failures").scope("vendor")).description("The number of failed gRPC requests")));
    }

    public SubProtocolResult subProtocol(@NonNull ConnectionContext ctx, @NonNull HttpPrologue prologue, @NonNull Http2Headers headers, @NonNull Http2StreamWriter streamWriter, int streamId, @NonNull Http2Settings serverSettings, @NonNull Http2Settings clientSettings, @NonNull StreamFlowControl flowControl, @NonNull Http2StreamState currentStreamState, @NonNull Router router) {
        Objects.requireNonNull(ctx);
        Objects.requireNonNull(prologue);
        Objects.requireNonNull(headers);
        Objects.requireNonNull(streamWriter);
        Objects.requireNonNull(serverSettings);
        Objects.requireNonNull(clientSettings);
        Objects.requireNonNull(flowControl);
        Objects.requireNonNull(currentStreamState);
        Objects.requireNonNull(router);
        this.requestCounter.increment();
        if (prologue.method() != Method.POST) {
            this.failedRequestCounter.increment();
            return NOT_SUPPORTED;
        }
        PbjRouting routing = (PbjRouting)router.routing(PbjRouting.class, (Routing)EMPTY);
        PbjMethodRoute route = routing.findRoute(prologue);
        if (route == null) {
            this.failedRequestCounter.increment();
            return new SubProtocolResult(true, (Http2SubProtocolSelector.SubProtocolHandler)new RouteNotFoundHandler(streamWriter, streamId, currentStreamState));
        }
        return new SubProtocolResult(true, (Http2SubProtocolSelector.SubProtocolHandler)new PbjProtocolHandler(headers, streamWriter, streamId, flowControl.outbound(), currentStreamState, this.config, route, this.deadlineDetector));
    }
}

