/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.pbj.grpc.helidon;

import com.hedera.pbj.grpc.helidon.PbjMethodRoute;
import com.hedera.pbj.grpc.helidon.PbjRoute;
import com.hedera.pbj.grpc.helidon.PbjServiceRoute;
import com.hedera.pbj.runtime.grpc.ServiceInterface;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.helidon.http.HttpPrologue;
import io.helidon.http.PathMatchers;
import io.helidon.webserver.Routing;
import io.helidon.webserver.ServerLifecycle;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class PbjRouting
implements Routing {
    @NonNull
    private final List<PbjRoute> routes;

    private PbjRouting(@NonNull Builder builder) {
        this.routes = new ArrayList<PbjRoute>(builder.routes);
    }

    @NonNull
    public Class<? extends Routing> routingType() {
        return PbjRouting.class;
    }

    public void beforeStart() {
        this.routes.forEach(ServerLifecycle::beforeStart);
    }

    public void afterStop() {
        this.routes.forEach(ServerLifecycle::afterStop);
    }

    @Nullable
    PbjMethodRoute findRoute(@NonNull HttpPrologue prologue) {
        for (PbjRoute route : this.routes) {
            PathMatchers.MatchResult accepts = route.accepts(prologue);
            if (!accepts.accepted()) continue;
            return route.toPbjMethodRoute(prologue);
        }
        return null;
    }

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements io.helidon.common.Builder<Builder, PbjRouting> {
        private final List<PbjRoute> routes = new LinkedList<PbjRoute>();

        private Builder() {
        }

        @NonNull
        public PbjRouting build() {
            return new PbjRouting(this);
        }

        @NonNull
        public Builder service(@NonNull ServiceInterface service) {
            return this.route(new PbjServiceRoute(service));
        }

        @NonNull
        private Builder route(@NonNull PbjRoute route) {
            this.routes.add(route);
            return this;
        }
    }
}

