/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal;

import dagger.Lazy;
import dagger.internal.Preconditions;
import dagger.internal.Provider;
import dagger.internal.Providers;
import org.jspecify.annotations.Nullable;

public final class DoubleCheck<T>
implements Provider<T>,
Lazy<T> {
    private static final Object UNINITIALIZED = new Object();
    private volatile @Nullable Provider<T> provider;
    private volatile @Nullable Object instance = UNINITIALIZED;

    private DoubleCheck(Provider<T> provider) {
        assert (provider != null);
        this.provider = provider;
    }

    @Override
    public T get() {
        @Nullable Object result = this.instance;
        if (result == UNINITIALIZED) {
            result = this.getSynchronized();
        }
        return (T)result;
    }

    private synchronized @Nullable Object getSynchronized() {
        @Nullable Object result = this.instance;
        if (result == UNINITIALIZED) {
            result = this.provider.get();
            this.instance = DoubleCheck.reentrantCheck(this.instance, result);
            this.provider = null;
        }
        return result;
    }

    private static @Nullable Object reentrantCheck(@Nullable Object currentInstance, @Nullable Object newInstance) {
        boolean isReentrant;
        boolean bl = isReentrant = currentInstance != UNINITIALIZED;
        if (isReentrant && currentInstance != newInstance) {
            throw new IllegalStateException("Scoped provider was invoked recursively returning different results: " + currentInstance + " & " + newInstance + ". This is likely due to a circular dependency.");
        }
        return newInstance;
    }

    public static <T> Provider<T> provider(Provider<T> delegate) {
        Preconditions.checkNotNull(delegate);
        if (delegate instanceof DoubleCheck) {
            return delegate;
        }
        return new DoubleCheck<T>(delegate);
    }

    @Deprecated
    public static <P extends javax.inject.Provider<T>, T> javax.inject.Provider<T> provider(P delegate) {
        return DoubleCheck.provider(Providers.asDaggerProvider(delegate));
    }

    public static <T> Lazy<T> lazy(Provider<T> provider) {
        if (provider instanceof Lazy) {
            Lazy lazy = (Lazy)((Object)provider);
            return lazy;
        }
        return new DoubleCheck<T>(Preconditions.checkNotNull(provider));
    }

    public static <P extends javax.inject.Provider<T>, T> Lazy<T> lazy(P provider) {
        return DoubleCheck.lazy(Providers.asDaggerProvider(provider));
    }
}

