/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.account;

import java.util.NavigableMap;
import java.util.Optional;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.units.bigints.UInt256;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.datatypes.Hash;
import org.hyperledger.besu.datatypes.Wei;
import org.hyperledger.besu.evm.account.AbstractCodeDelegationAccount;
import org.hyperledger.besu.evm.account.Account;
import org.hyperledger.besu.evm.account.AccountStorageEntry;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.worldstate.WorldUpdater;

public class CodeDelegationAccount
extends AbstractCodeDelegationAccount
implements Account {
    private final Account wrappedAccount;

    public CodeDelegationAccount(WorldUpdater worldUpdater, Account wrappedAccount, Address codeDelegationAddress, GasCalculator gasCalculator) {
        super(worldUpdater, codeDelegationAddress, gasCalculator);
        this.wrappedAccount = wrappedAccount;
    }

    @Override
    public Address getAddress() {
        return this.wrappedAccount.getAddress();
    }

    @Override
    public boolean isStorageEmpty() {
        return this.wrappedAccount.isStorageEmpty();
    }

    @Override
    public Optional<Address> codeDelegationAddress() {
        return super.codeDelegationAddress();
    }

    @Override
    public Hash getAddressHash() {
        return this.wrappedAccount.getAddressHash();
    }

    @Override
    public long getNonce() {
        return this.wrappedAccount.getNonce();
    }

    @Override
    public Wei getBalance() {
        return this.wrappedAccount.getBalance();
    }

    @Override
    public Bytes getCode() {
        return this.wrappedAccount.getCode();
    }

    @Override
    public Hash getCodeHash() {
        return this.wrappedAccount.getCodeHash();
    }

    @Override
    public UInt256 getStorageValue(UInt256 key) {
        return this.wrappedAccount.getStorageValue(key);
    }

    @Override
    public UInt256 getOriginalStorageValue(UInt256 key) {
        return this.wrappedAccount.getOriginalStorageValue(key);
    }

    @Override
    public boolean isEmpty() {
        return this.wrappedAccount.isEmpty();
    }

    @Override
    public boolean hasCode() {
        return !this.getCode().isEmpty();
    }

    @Override
    public NavigableMap<Bytes32, AccountStorageEntry> storageEntriesFrom(Bytes32 startKeyHash, int limit) {
        return this.wrappedAccount.storageEntriesFrom(startKeyHash, limit);
    }
}

