/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.code;

class WorkList {
    boolean[] marked;
    int[] items;
    int nextIndex;
    int listEnd;

    WorkList(int size) {
        this.marked = new boolean[size];
        this.items = new int[size];
        this.nextIndex = 0;
        this.listEnd = -1;
    }

    int take() {
        if (this.nextIndex > this.listEnd) {
            return -1;
        }
        int result = this.items[this.nextIndex];
        ++this.nextIndex;
        return result;
    }

    boolean isComplete() {
        return this.nextIndex >= this.items.length;
    }

    void put(int item) {
        if (!this.marked[item]) {
            ++this.listEnd;
            this.items[this.listEnd] = item;
            this.marked[item] = true;
        }
    }

    int getFirstUnmarkedItem() {
        for (int i = 0; i < this.marked.length; ++i) {
            if (this.marked[i]) continue;
            return i;
        }
        return -1;
    }
}

