/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.internal;

import com.google.common.base.Preconditions;
import java.lang.reflect.Array;
import java.util.Arrays;
import org.hyperledger.besu.evm.internal.OverflowException;
import org.hyperledger.besu.evm.internal.UnderflowException;

public class FixedStack<T> {
    private final T[] entries;
    private final int maxSize;
    private int top;

    public FixedStack(int maxSize, Class<T> klass) {
        Preconditions.checkArgument((maxSize >= 0 ? 1 : 0) != 0, (Object)"max size must be non-negative");
        this.entries = (Object[])Array.newInstance(klass, maxSize);
        this.maxSize = maxSize;
        this.top = -1;
    }

    public T get(int offset) {
        if (offset < 0 || offset >= this.size()) {
            throw new UnderflowException();
        }
        return this.entries[this.top - offset];
    }

    public T pop() {
        if (this.top < 0) {
            throw new UnderflowException();
        }
        T removed = this.entries[this.top];
        this.entries[this.top--] = null;
        return removed;
    }

    public T peek() {
        if (this.top < 0) {
            return null;
        }
        return this.entries[this.top];
    }

    public void bulkPop(int items) {
        Preconditions.checkArgument((items > 0 ? 1 : 0) != 0, (Object)"number of items to pop must be greater than 0");
        if (items > this.size()) {
            throw new UnderflowException();
        }
        Arrays.fill(this.entries, this.top - items + 1, this.top + 1, null);
        this.top -= items;
    }

    public void preserveTop(int cutPoint, int itemsToKeep) {
        Preconditions.checkArgument((cutPoint >= 0 ? 1 : 0) != 0, (Object)"cutPoint must be positive");
        Preconditions.checkArgument((itemsToKeep >= 0 ? 1 : 0) != 0, (Object)"itemsToKeep must be positive");
        if (itemsToKeep == 0) {
            if (cutPoint < this.size()) {
                this.bulkPop(this.top - cutPoint);
            }
        } else {
            int targetSize = cutPoint + itemsToKeep;
            int currentSize = this.size();
            if (targetSize > currentSize) {
                throw new UnderflowException();
            }
            if (targetSize < currentSize) {
                System.arraycopy(this.entries, currentSize - itemsToKeep, this.entries, cutPoint, itemsToKeep);
                Arrays.fill(this.entries, targetSize, currentSize, null);
                this.top = targetSize - 1;
            }
        }
    }

    public void push(T operand) {
        int nextTop = this.top + 1;
        if (nextTop == this.maxSize) {
            throw new OverflowException();
        }
        this.entries[nextTop] = operand;
        this.top = nextTop;
    }

    public void set(int offset, T operand) {
        if (offset < 0) {
            throw new UnderflowException();
        }
        if (offset >= this.size()) {
            throw new OverflowException();
        }
        this.entries[this.top - offset] = operand;
    }

    public int size() {
        return this.top + 1;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.entries.length; ++i) {
            builder.append(String.format("%n0x%04X ", i)).append(this.entries[i]);
        }
        return builder.toString();
    }

    public int hashCode() {
        return Arrays.hashCode(this.entries);
    }

    public boolean equals(Object other) {
        if (!(other instanceof FixedStack)) {
            return false;
        }
        FixedStack that = (FixedStack)other;
        return Arrays.deepEquals(this.entries, that.entries);
    }

    public boolean isFull() {
        return this.top + 1 >= this.maxSize;
    }

    public boolean isEmpty() {
        return this.top < 0;
    }
}

