/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.evm.Code;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.operation.AbstractFixedCostOperation;
import org.hyperledger.besu.evm.operation.InvalidOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class ExchangeOperation
extends AbstractFixedCostOperation {
    public static final int OPCODE = 232;
    static final Operation.OperationResult exchangeSuccess = new Operation.OperationResult(3L, null);

    public ExchangeOperation(GasCalculator gasCalculator) {
        super(232, "EXCHANGE", 0, 1, gasCalculator, gasCalculator.getVeryLowTierGasCost());
    }

    @Override
    public Operation.OperationResult executeFixedCostOperation(MessageFrame frame, EVM evm) {
        Code code = frame.getCode();
        if (code.getEofVersion() == 0) {
            return InvalidOperation.INVALID_RESULT;
        }
        int pc = frame.getPC();
        int imm = code.readU8(pc + 1);
        int n = (imm >> 4) + 1;
        int m = (imm & 0xF) + 1 + n;
        Bytes tmp = frame.getStackItem(n);
        frame.setStackItem(n, frame.getStackItem(m));
        frame.setStackItem(m, tmp);
        frame.setPC(pc + 1);
        return exchangeSuccess;
    }
}

