/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.datatypes.Wei;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.internal.Words;
import org.hyperledger.besu.evm.operation.AbstractExtCallOperation;

public class ExtStaticCallOperation
extends AbstractExtCallOperation {
    public static final int OPCODE = 251;

    public ExtStaticCallOperation(GasCalculator gasCalculator) {
        super(251, "EXTSTATICCALL", 3, 1, gasCalculator);
    }

    @Override
    protected Wei value(MessageFrame frame) {
        return Wei.ZERO;
    }

    @Override
    protected Wei apparentValue(MessageFrame frame) {
        return this.value(frame);
    }

    @Override
    protected long inputDataOffset(MessageFrame frame) {
        return Words.clampedToLong(frame.getStackItem(1));
    }

    @Override
    protected long inputDataLength(MessageFrame frame) {
        return Words.clampedToLong(frame.getStackItem(2));
    }

    @Override
    protected Address address(MessageFrame frame) {
        return this.to(frame);
    }

    @Override
    protected Address sender(MessageFrame frame) {
        return frame.getRecipientAddress();
    }

    @Override
    protected boolean isStatic(MessageFrame frame) {
        return true;
    }
}

