/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.internal.Words;
import org.hyperledger.besu.evm.operation.AbstractOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class RevertOperation
extends AbstractOperation {
    public static final int OPCODE = 253;

    public RevertOperation(GasCalculator gasCalculator) {
        super(253, "REVERT", 2, 0, gasCalculator);
    }

    @Override
    public Operation.OperationResult execute(MessageFrame frame, EVM evm) {
        long from = Words.clampedToLong(frame.popStackItem());
        long length = Words.clampedToLong(frame.popStackItem());
        long cost = this.gasCalculator().memoryExpansionGasCost(frame, from, length);
        if (frame.getRemainingGas() < cost) {
            return new Operation.OperationResult(cost, ExceptionalHaltReason.INSUFFICIENT_GAS);
        }
        Bytes reason = frame.readMemory(from, length);
        frame.setOutputData(reason);
        frame.setRevertReason(reason);
        frame.setState(MessageFrame.State.REVERT);
        return new Operation.OperationResult(cost, null);
    }
}

