/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import java.math.BigInteger;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.operation.AbstractFixedCostOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class SDivOperation
extends AbstractFixedCostOperation {
    private static final Operation.OperationResult sdivSuccess = new Operation.OperationResult(5L, null);

    public SDivOperation(GasCalculator gasCalculator) {
        super(5, "SDIV", 2, 1, gasCalculator, gasCalculator.getLowTierGasCost());
    }

    @Override
    public Operation.OperationResult executeFixedCostOperation(MessageFrame frame, EVM evm) {
        return SDivOperation.staticOperation(frame);
    }

    public static Operation.OperationResult staticOperation(MessageFrame frame) {
        Bytes value0 = frame.popStackItem();
        Bytes value1 = frame.popStackItem();
        if (value1.isZero()) {
            frame.pushStackItem(Bytes.EMPTY);
        } else {
            BigInteger b2;
            BigInteger b1 = value0.size() < 32 ? new BigInteger(1, value0.toArrayUnsafe()) : new BigInteger(value0.toArrayUnsafe());
            BigInteger result = b1.divide(b2 = value1.size() < 32 ? new BigInteger(1, value1.toArrayUnsafe()) : new BigInteger(value1.toArrayUnsafe()));
            Bytes resultBytes = Bytes.wrap((byte[])result.toByteArray());
            if (resultBytes.size() > 32) {
                resultBytes = resultBytes.slice(resultBytes.size() - 32, 32);
            }
            frame.pushStackItem((Bytes)Bytes32.leftPad((Bytes)resultBytes, (byte)(result.signum() < 0 ? (byte)-1 : 0)));
        }
        return sdivSuccess;
    }
}

