/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.bytes.MutableBytes;
import org.apache.tuweni.bytes.MutableBytes32;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.operation.AbstractFixedCostOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class SignExtendOperation
extends AbstractFixedCostOperation {
    private static final Operation.OperationResult signExtendSuccess = new Operation.OperationResult(5L, null);

    public SignExtendOperation(GasCalculator gasCalculator) {
        super(11, "SIGNEXTEND", 2, 1, gasCalculator, gasCalculator.getLowTierGasCost());
    }

    @Override
    public Operation.OperationResult executeFixedCostOperation(MessageFrame frame, EVM evm) {
        return SignExtendOperation.staticOperation(frame);
    }

    public static Operation.OperationResult staticOperation(MessageFrame frame) {
        Bytes value0 = frame.popStackItem().trimLeadingZeros();
        Bytes32 value1 = Bytes32.leftPad((Bytes)frame.popStackItem());
        MutableBytes32 result = MutableBytes32.create();
        int value0size = value0.size();
        if (value0size > 1) {
            frame.pushStackItem((Bytes)value1);
            return signExtendSuccess;
        }
        int value0Value = value0.toInt();
        if (value0Value >= 31) {
            frame.pushStackItem((Bytes)value1);
            return signExtendSuccess;
        }
        int byteIndex = 31 - value0.toInt();
        byte toSet = value1.get(byteIndex) < 0 ? (byte)-1 : 0;
        result.mutableSlice(0, byteIndex).fill(toSet);
        value1.slice(byteIndex).copyTo((MutableBytes)result, byteIndex);
        frame.pushStackItem((Bytes)result);
        return signExtendSuccess;
    }
}

