/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.precompile;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.crypto.altbn128.AbstractFqp;
import org.hyperledger.besu.crypto.altbn128.AltBn128Fq12Pairer;
import org.hyperledger.besu.crypto.altbn128.AltBn128Fq2Point;
import org.hyperledger.besu.crypto.altbn128.AltBn128Point;
import org.hyperledger.besu.crypto.altbn128.Fq;
import org.hyperledger.besu.crypto.altbn128.Fq12;
import org.hyperledger.besu.crypto.altbn128.Fq2;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.precompile.AbstractAltBnPrecompiledContract;
import org.hyperledger.besu.evm.precompile.PrecompiledContract;

public class AltBN128PairingPrecompiledContract
extends AbstractAltBnPrecompiledContract {
    private static final int FIELD_LENGTH = 32;
    private static final int PARAMETER_LENGTH = 192;
    static final Bytes FALSE = Bytes.fromHexString((CharSequence)"0x0000000000000000000000000000000000000000000000000000000000000000");
    public static final Bytes TRUE = Bytes.fromHexString((CharSequence)"0x0000000000000000000000000000000000000000000000000000000000000001");
    private final long pairingGasCost;
    private final long baseGasCost;

    private AltBN128PairingPrecompiledContract(GasCalculator gasCalculator, long pairingGasCost, long baseGasCost) {
        super("AltBN128Pairing", gasCalculator, (byte)3, 2147483520);
        this.pairingGasCost = pairingGasCost;
        this.baseGasCost = baseGasCost;
    }

    public static AltBN128PairingPrecompiledContract byzantium(GasCalculator gasCalculator) {
        return new AltBN128PairingPrecompiledContract(gasCalculator, 80000L, 100000L);
    }

    public static AltBN128PairingPrecompiledContract istanbul(GasCalculator gasCalculator) {
        return new AltBN128PairingPrecompiledContract(gasCalculator, 34000L, 45000L);
    }

    @Override
    public long gasRequirement(Bytes input) {
        int parameters = input.size() / 192;
        return this.pairingGasCost * (long)parameters + this.baseGasCost;
    }

    @Override
    @Nonnull
    public PrecompiledContract.PrecompileContractResult computePrecompile(Bytes input, @Nonnull MessageFrame messageFrame) {
        if (input.isEmpty()) {
            return PrecompiledContract.PrecompileContractResult.success(TRUE);
        }
        if (input.size() % 192 != 0) {
            return PrecompiledContract.PrecompileContractResult.halt(null, Optional.of(ExceptionalHaltReason.PRECOMPILE_ERROR));
        }
        if (useNative) {
            return this.computeNative(input, messageFrame);
        }
        return AltBN128PairingPrecompiledContract.computeDefault(input);
    }

    @Nonnull
    private static PrecompiledContract.PrecompileContractResult computeDefault(Bytes input) {
        int parameters = input.size() / 192;
        ArrayList<AltBn128Point> a = new ArrayList<AltBn128Point>();
        ArrayList<AltBn128Fq2Point> b = new ArrayList<AltBn128Fq2Point>();
        for (int i = 0; i < parameters; ++i) {
            BigInteger p1_x = AltBN128PairingPrecompiledContract.extractParameter(input, i * 192, 32);
            BigInteger p1_y = AltBN128PairingPrecompiledContract.extractParameter(input, i * 192 + 32, 32);
            AltBn128Point p1 = new AltBn128Point(Fq.create((BigInteger)p1_x), Fq.create((BigInteger)p1_y));
            if (!p1.isOnCurve()) {
                return PrecompiledContract.PrecompileContractResult.halt(null, Optional.of(ExceptionalHaltReason.PRECOMPILE_ERROR));
            }
            a.add(p1);
            BigInteger p2_xImag = AltBN128PairingPrecompiledContract.extractParameter(input, i * 192 + 64, 32);
            BigInteger p2_xReal = AltBN128PairingPrecompiledContract.extractParameter(input, i * 192 + 96, 32);
            BigInteger p2_yImag = AltBN128PairingPrecompiledContract.extractParameter(input, i * 192 + 128, 32);
            BigInteger p2_yReal = AltBN128PairingPrecompiledContract.extractParameter(input, i * 192 + 160, 32);
            Fq2 p2_x = Fq2.create((BigInteger)p2_xReal, (BigInteger)p2_xImag);
            Fq2 p2_y = Fq2.create((BigInteger)p2_yReal, (BigInteger)p2_yImag);
            AltBn128Fq2Point p2 = new AltBn128Fq2Point(p2_x, p2_y);
            if (!p2.isOnCurve() || !p2.isInGroup()) {
                return PrecompiledContract.PrecompileContractResult.halt(null, Optional.of(ExceptionalHaltReason.PRECOMPILE_ERROR));
            }
            b.add(p2);
        }
        Fq12 exponent = Fq12.one();
        for (int i = 0; i < parameters; ++i) {
            exponent = (Fq12)exponent.multiply((AbstractFqp)AltBn128Fq12Pairer.pair((AltBn128Point)((AltBn128Point)a.get(i)), (AltBn128Fq2Point)((AltBn128Fq2Point)b.get(i))));
        }
        if (AltBn128Fq12Pairer.finalize((Fq12)exponent).equals((Object)Fq12.one())) {
            return PrecompiledContract.PrecompileContractResult.success(TRUE);
        }
        return PrecompiledContract.PrecompileContractResult.success(FALSE);
    }

    private static BigInteger extractParameter(Bytes input, int offset, int length) {
        if (offset > input.size() || length == 0) {
            return BigInteger.ZERO;
        }
        byte[] raw = Arrays.copyOfRange(input.toArrayUnsafe(), offset, offset + length);
        return new BigInteger(1, raw);
    }
}

