/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.worldstate;

import java.util.ArrayList;
import java.util.Collection;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.evm.account.Account;
import org.hyperledger.besu.evm.internal.EvmConfiguration;
import org.hyperledger.besu.evm.worldstate.AbstractWorldUpdater;
import org.hyperledger.besu.evm.worldstate.UpdateTrackingAccount;
import org.hyperledger.besu.evm.worldstate.WorldView;

public class StackedUpdater<W extends WorldView, A extends Account>
extends AbstractWorldUpdater<AbstractWorldUpdater<W, A>, UpdateTrackingAccount<A>> {
    public StackedUpdater(AbstractWorldUpdater<W, A> world, EvmConfiguration evmConfiguration) {
        super(world, evmConfiguration);
    }

    @Override
    protected UpdateTrackingAccount<A> getForMutation(Address address) {
        AbstractWorldUpdater wrapped = (AbstractWorldUpdater)this.wrappedWorldView();
        UpdateTrackingAccount wrappedTracker = wrapped.updatedAccounts.get(address);
        if (wrappedTracker != null) {
            return wrappedTracker;
        }
        if (wrapped.deletedAccounts.contains(address)) {
            return null;
        }
        Object account = ((AbstractWorldUpdater)this.wrappedWorldView()).getForMutation(address);
        return account == null ? null : new UpdateTrackingAccount(account);
    }

    @Override
    public Collection<? extends Account> getTouchedAccounts() {
        return new ArrayList(this.getUpdatedAccounts());
    }

    @Override
    public Collection<Address> getDeletedAccountAddresses() {
        return new ArrayList<Address>(this.getDeletedAccounts());
    }

    @Override
    public void revert() {
        this.getDeletedAccounts().clear();
        this.getUpdatedAccounts().clear();
    }

    @Override
    public void commit() {
        AbstractWorldUpdater wrapped = (AbstractWorldUpdater)this.wrappedWorldView();
        this.getDeletedAccounts().forEach(wrapped.updatedAccounts::remove);
        this.getUpdatedAccounts().forEach(a -> wrapped.deletedAccounts.remove(a.getAddress()));
        wrapped.deletedAccounts.addAll(this.getDeletedAccounts());
        for (UpdateTrackingAccount update : this.getUpdatedAccounts()) {
            UpdateTrackingAccount<Address> existing = wrapped.updatedAccounts.get(update.getAddress());
            if (existing == null) {
                existing = (UpdateTrackingAccount<Address>)update.getWrappedAccount();
                if (existing == null) {
                    existing = new UpdateTrackingAccount<Address>(update.getAddress());
                }
                wrapped.updatedAccounts.put(existing.getAddress(), existing);
            }
            existing.setNonce(update.getNonce());
            existing.setBalance(update.getBalance());
            if (update.codeWasUpdated()) {
                existing.setCode(update.getCode());
            }
            if (update.getStorageWasCleared()) {
                existing.clearStorage();
            }
            update.getUpdatedStorage().forEach(existing::setStorageValue);
        }
    }

    @Override
    public void markTransactionBoundary() {
        this.getUpdatedAccounts().forEach(UpdateTrackingAccount::markTransactionBoundary);
    }
}

