/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.service.registry;

import io.helidon.common.types.ResolvedType;
import io.helidon.common.types.TypeName;
import io.helidon.service.registry.ServiceDescriptor;
import java.util.Objects;
import java.util.Set;

public class VirtualDescriptor
implements ServiceDescriptor<Object> {
    private static final TypeName TYPE = TypeName.create(VirtualDescriptor.class);
    private final Set<ResolvedType> contracts;
    private final TypeName serviceType;
    private final TypeName descriptorType;
    private final double weight;
    private final Object instance;

    VirtualDescriptor(TypeName contract) {
        this(contract, 1100.0, TYPE);
    }

    VirtualDescriptor(TypeName contract, double weight, Object instance) {
        this.contracts = Set.of(ResolvedType.create((TypeName)contract));
        this.serviceType = contract;
        this.descriptorType = ((TypeName.Builder)TypeName.builder((TypeName)TYPE).className(TYPE.className() + "_" + contract.className() + "__VirtualDescriptor")).build();
        this.weight = weight;
        this.instance = instance;
    }

    @Override
    public TypeName serviceType() {
        return this.serviceType;
    }

    @Override
    public TypeName descriptorType() {
        return this.descriptorType;
    }

    @Override
    public Set<ResolvedType> contracts() {
        return this.contracts;
    }

    public double weight() {
        return this.weight;
    }

    public int hashCode() {
        return Objects.hash(this.serviceType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VirtualDescriptor)) {
            return false;
        }
        VirtualDescriptor that = (VirtualDescriptor)o;
        return Objects.equals(this.serviceType, that.serviceType) && this.instance == that.instance;
    }

    public String toString() {
        return "VirtualDescriptor for contract " + String.valueOf(this.serviceType) + " (" + this.weight + ")";
    }
}

