/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hapi.utils.ethereum;

import com.esaulpaugh.headlong.rlp.RLPEncoder;
import com.esaulpaugh.headlong.util.Integers;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.hedera.node.app.hapi.utils.EthSigsUtils;
import com.hedera.node.app.hapi.utils.ethereum.EthTxData;
import com.sun.jna.ptr.LongByReference;
import com.sun.jna.ptr.PointerByReference;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.commons.codec.binary.Hex;
import org.bouncycastle.asn1.sec.SECNamedCurves;
import org.bouncycastle.jcajce.provider.digest.Keccak;
import org.hyperledger.besu.nativelib.secp256k1.LibSecp256k1;

public record EthTxSigs(byte[] publicKey, byte[] address) {
    private static final BigInteger N = SECNamedCurves.getByName((String)"secp256k1").getN();

    public static EthTxSigs extractSignatures(EthTxData ethTx) {
        byte[] message = EthTxSigs.calculateSignableMessage(ethTx);
        LibSecp256k1.secp256k1_pubkey pubKey = EthTxSigs.extractSig(ethTx.recId(), ethTx.r(), ethTx.s(), message);
        byte[] address = EthSigsUtils.recoverAddressFromPubKey(pubKey);
        byte[] compressedKey = EthTxSigs.recoverCompressedPubKey(pubKey);
        return new EthTxSigs(compressedKey, address);
    }

    public static byte[] calculateSignableMessage(EthTxData ethTx) {
        return switch (ethTx.type()) {
            default -> throw new MatchException(null, null);
            case EthTxData.EthTransactionType.LEGACY_ETHEREUM -> {
                if (ethTx.chainId() != null && ethTx.chainId().length > 0) {
                    yield RLPEncoder.list((Object[])new Object[]{Integers.toBytes((long)ethTx.nonce()), ethTx.gasPrice(), Integers.toBytes((long)ethTx.gasLimit()), ethTx.to(), Integers.toBytesUnsigned((BigInteger)ethTx.value()), ethTx.callData(), ethTx.chainId(), Integers.toBytes((int)0), Integers.toBytes((int)0)});
                }
                yield RLPEncoder.list((Object[])new Object[]{Integers.toBytes((long)ethTx.nonce()), ethTx.gasPrice(), Integers.toBytes((long)ethTx.gasLimit()), ethTx.to(), Integers.toBytesUnsigned((BigInteger)ethTx.value()), ethTx.callData()});
            }
            case EthTxData.EthTransactionType.EIP1559 -> RLPEncoder.sequence((Object[])new Object[]{Integers.toBytes((int)2), new Object[]{ethTx.chainId(), Integers.toBytes((long)ethTx.nonce()), ethTx.maxPriorityGas(), ethTx.maxGas(), Integers.toBytes((long)ethTx.gasLimit()), ethTx.to(), Integers.toBytesUnsigned((BigInteger)ethTx.value()), ethTx.callData(), new Object[0]}});
            case EthTxData.EthTransactionType.EIP2930 -> RLPEncoder.sequence((Object[])new Object[]{Integers.toBytes((int)1), new Object[]{ethTx.chainId(), Integers.toBytes((long)ethTx.nonce()), ethTx.gasPrice(), Integers.toBytes((long)ethTx.gasLimit()), ethTx.to(), Integers.toBytesUnsigned((BigInteger)ethTx.value()), ethTx.callData(), new Object[0]}});
        };
    }

    static byte[] recoverCompressedPubKey(LibSecp256k1.secp256k1_pubkey pubKey) {
        ByteBuffer recoveredFullKey = ByteBuffer.allocate(33);
        LongByReference fullKeySize = new LongByReference((long)recoveredFullKey.limit());
        LibSecp256k1.secp256k1_ec_pubkey_serialize((PointerByReference)LibSecp256k1.CONTEXT, (ByteBuffer)recoveredFullKey, (LongByReference)fullKeySize, (LibSecp256k1.secp256k1_pubkey)pubKey, (int)258);
        return recoveredFullKey.array();
    }

    private static LibSecp256k1.secp256k1_pubkey extractSig(int recId, byte[] r, byte[] s, byte[] message) {
        recId = Math.floorMod(recId, 2);
        byte[] dataHash = new Keccak.Digest256().digest(message);
        EthTxSigs.checkInBounds(r);
        EthTxSigs.checkInBounds(s);
        byte[] signature = EthTxSigs.concatLeftPadded(r, s);
        LibSecp256k1.secp256k1_ecdsa_recoverable_signature parsedSignature = new LibSecp256k1.secp256k1_ecdsa_recoverable_signature();
        if (LibSecp256k1.secp256k1_ecdsa_recoverable_signature_parse_compact((PointerByReference)LibSecp256k1.CONTEXT, (LibSecp256k1.secp256k1_ecdsa_recoverable_signature)parsedSignature, (byte[])signature, (int)recId) == 0) {
            throw new IllegalArgumentException("Could not parse signature");
        }
        LibSecp256k1.secp256k1_pubkey newPubKey = new LibSecp256k1.secp256k1_pubkey();
        if (LibSecp256k1.secp256k1_ecdsa_recover((PointerByReference)LibSecp256k1.CONTEXT, (LibSecp256k1.secp256k1_pubkey)newPubKey, (LibSecp256k1.secp256k1_ecdsa_recoverable_signature)parsedSignature, (byte[])dataHash) == 0) {
            throw new IllegalArgumentException("Could not recover signature");
        }
        return newPubKey;
    }

    @VisibleForTesting
    static byte[] concatLeftPadded(byte[] r, byte[] s) {
        byte[] signature = new byte[64];
        int rLeadingZeros = 32 - r.length;
        System.arraycopy(r, 0, signature, rLeadingZeros, r.length);
        int sLeadingZeros = 32 - s.length;
        System.arraycopy(s, 0, signature, 32 + sLeadingZeros, s.length);
        return signature;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        EthTxSigs ethTxSigs = (EthTxSigs)other;
        if (!Arrays.equals(this.publicKey, ethTxSigs.publicKey)) {
            return false;
        }
        return Arrays.equals(this.address, ethTxSigs.address);
    }

    @Override
    public int hashCode() {
        int result = Arrays.hashCode(this.publicKey);
        result = 31 * result + Arrays.hashCode(this.address);
        return result;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("publicKey", (Object)Hex.encodeHexString((byte[])this.publicKey)).add("address", (Object)Hex.encodeHexString((byte[])this.address)).toString();
    }

    private static void checkInBounds(@NonNull byte[] curvePoint) {
        BigInteger bi = new BigInteger(1, curvePoint);
        if (bi.compareTo(BigInteger.ONE) < 0) {
            throw new IllegalArgumentException("Curve point must be >= 1");
        }
        if (bi.compareTo(N) >= 0) {
            throw new IllegalArgumentException("Curve point must be < N");
        }
    }
}

