/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hapi.utils.fee;

import com.hedera.node.app.hapi.utils.fee.FeeBuilder;
import com.hedera.node.app.hapi.utils.fee.SigValueObj;
import com.hederahashgraph.api.proto.java.FeeComponents;
import com.hederahashgraph.api.proto.java.FeeData;
import com.hederahashgraph.api.proto.java.ResponseType;
import com.hederahashgraph.api.proto.java.TransactionBody;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public final class FileFeeBuilder
extends FeeBuilder {
    @Inject
    public FileFeeBuilder() {
    }

    public FeeData getFileContentQueryFeeMatrices(int contentSize, ResponseType responseType) {
        long bpt = 0L;
        long vpt = 0L;
        long rbs = 0L;
        long sbs = 0L;
        long gas = 0L;
        long tv = 0L;
        long bpr = 0L;
        long sbpr = 0L;
        bpt = FileFeeBuilder.calculateBpt();
        bpr = 16L + (long)FileFeeBuilder.getStateProofSize(responseType);
        sbpr = 24L + (long)contentSize;
        FeeComponents feeMatrices = FeeComponents.newBuilder().setBpt(bpt).setVpt(vpt).setRbh(rbs).setSbh(sbs).setGas(gas).setTv(tv).setBpr(bpr).setSbpr(sbpr).build();
        return FileFeeBuilder.getQueryFeeDataMatrices(feeMatrices);
    }

    public FeeData getSystemDeleteFileTxFeeMatrices(TransactionBody txBody, SigValueObj numSignatures) {
        long bpt = 0L;
        long vpt = 0L;
        long rbs = 0L;
        long sbs = 0L;
        long gas = 0L;
        long tv = 0L;
        long bpr = 0L;
        long sbpr = 0L;
        bpt = FileFeeBuilder.getCommonTransactionBodyBytes(txBody);
        bpt = bpt + 24L + 8L;
        vpt = numSignatures.getTotalSigCount();
        rbs = FileFeeBuilder.calculateRbs(txBody);
        long rbsNetwork = FileFeeBuilder.getDefaultRbhNetworkSize();
        FeeComponents feeMatricesForTx = FeeComponents.newBuilder().setBpt(bpt).setVpt(vpt).setRbh(rbs).setSbh(sbs).setGas(gas).setTv(tv).setBpr(bpr).setSbpr(sbpr).build();
        return FileFeeBuilder.getFeeDataMatrices(feeMatricesForTx, numSignatures.getPayerAcctSigCount(), rbsNetwork);
    }

    public FeeData getSystemUnDeleteFileTxFeeMatrices(TransactionBody txBody, SigValueObj numSignatures) {
        long bpt = 0L;
        long vpt = 0L;
        long rbs = 0L;
        long sbs = 0L;
        long gas = 0L;
        long tv = 0L;
        long bpr = 0L;
        long sbpr = 0L;
        bpt = FileFeeBuilder.getCommonTransactionBodyBytes(txBody);
        bpt = bpt + 24L + 8L;
        vpt = numSignatures.getTotalSigCount();
        rbs = FileFeeBuilder.calculateRbs(txBody);
        long rbsNetwork = FileFeeBuilder.getDefaultRbhNetworkSize();
        FeeComponents feeMatricesForTx = FeeComponents.newBuilder().setBpt(bpt).setVpt(vpt).setRbh(rbs).setSbh(sbs).setGas(gas).setTv(tv).setBpr(bpr).setSbpr(sbpr).build();
        return FileFeeBuilder.getFeeDataMatrices(feeMatricesForTx, numSignatures.getPayerAcctSigCount(), rbsNetwork);
    }

    public FeeData getFileDeleteTxFeeMatrices(TransactionBody txBody, SigValueObj sigValObj) {
        long bpt = 0L;
        long vpt = 0L;
        long rbs = 0L;
        long sbs = 0L;
        long gas = 0L;
        long tv = 0L;
        long bpr = 0L;
        long sbpr = 0L;
        long txBodySize = FileFeeBuilder.getCommonTransactionBodyBytes(txBody);
        bpt = txBodySize + 24L + (long)sigValObj.getSignatureSize();
        vpt = sigValObj.getTotalSigCount();
        bpr = 4L;
        rbs = FileFeeBuilder.calculateRbs(txBody);
        long rbsNetwork = FileFeeBuilder.getDefaultRbhNetworkSize();
        FeeComponents feeMatricesForTx = FeeComponents.newBuilder().setBpt(bpt).setVpt(vpt).setRbh(rbs).setSbh(sbs).setGas(gas).setTv(tv).setBpr(bpr).setSbpr(sbpr).build();
        return FileFeeBuilder.getFeeDataMatrices(feeMatricesForTx, sigValObj.getPayerAcctSigCount(), rbsNetwork);
    }
}

