/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hapi.utils.fee;

import com.hedera.node.app.hapi.utils.builder.RequestBuilder;
import com.hedera.node.app.hapi.utils.fee.FeeBuilder;
import com.hedera.node.app.hapi.utils.fee.SigValueObj;
import com.hederahashgraph.api.proto.java.ContractCallTransactionBody;
import com.hederahashgraph.api.proto.java.ContractCreateTransactionBody;
import com.hederahashgraph.api.proto.java.ContractFunctionResult;
import com.hederahashgraph.api.proto.java.ContractUpdateTransactionBody;
import com.hederahashgraph.api.proto.java.EthereumTransactionBody;
import com.hederahashgraph.api.proto.java.FeeComponents;
import com.hederahashgraph.api.proto.java.FeeData;
import com.hederahashgraph.api.proto.java.ResponseType;
import com.hederahashgraph.api.proto.java.Timestamp;
import com.hederahashgraph.api.proto.java.TransactionBody;
import java.time.Duration;
import java.time.Instant;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public final class SmartContractFeeBuilder
extends FeeBuilder {
    @Inject
    public SmartContractFeeBuilder() {
    }

    public FeeData getContractCreateTxFeeMatrices(TransactionBody txBody, SigValueObj sigValObj) {
        long bpt = 0L;
        long vpt = 0L;
        long rbs = 0L;
        long sbs = 0L;
        long gas = 0L;
        long tv = 0L;
        long bpr = 0L;
        long sbpr = 0L;
        long txBodySize = 0L;
        txBodySize = SmartContractFeeBuilder.getCommonTransactionBodyBytes(txBody);
        bpt = txBodySize + (long)this.getContractCreateTransactionBodySize(txBody) + (long)sigValObj.getSignatureSize();
        vpt = sigValObj.getTotalSigCount();
        bpr = 4L;
        rbs = (long)SmartContractFeeBuilder.getBaseTransactionRecordSize(txBody) * 90180L;
        long rbsNetwork = SmartContractFeeBuilder.getDefaultRbhNetworkSize() + 4320L;
        FeeComponents feeMatricesForTx = FeeComponents.newBuilder().setBpt(bpt).setVpt(vpt).setRbh(rbs).setSbh(sbs).setGas(gas).setTv(tv).setBpr(bpr).setSbpr(sbpr).build();
        return SmartContractFeeBuilder.getFeeDataMatrices(feeMatricesForTx, sigValObj.getPayerAcctSigCount(), rbsNetwork);
    }

    private int getContractCreateTransactionBodySize(TransactionBody txBody) {
        ContractCreateTransactionBody contractCreate = txBody.getContractCreateInstance();
        int adminKeySize = 0;
        int proxyAcctID = 0;
        if (contractCreate.hasAdminKey()) {
            adminKeySize = SmartContractFeeBuilder.getAccountKeyStorageSize(contractCreate.getAdminKey());
        }
        int newRealmAdminKeySize = 0;
        if (contractCreate.hasNewRealmAdminKey()) {
            newRealmAdminKeySize = SmartContractFeeBuilder.getAccountKeyStorageSize(contractCreate.getNewRealmAdminKey());
        }
        int constructParamSize = 0;
        if (contractCreate.getConstructorParameters() != null) {
            constructParamSize = contractCreate.getConstructorParameters().size();
        }
        if (contractCreate.hasProxyAccountID()) {
            proxyAcctID = 24;
        }
        int memoSize = 0;
        if (contractCreate.getMemo() != null) {
            memoSize = contractCreate.getMemoBytes().size();
        }
        return 72 + adminKeySize + proxyAcctID + constructParamSize + newRealmAdminKeySize + memoSize;
    }

    public FeeData getContractUpdateTxFeeMatrices(TransactionBody txBody, Timestamp contractExpiryTime, SigValueObj sigValObj) {
        long bpt = 0L;
        long vpt = 0L;
        long rbs = 0L;
        long sbs = 0L;
        long gas = 0L;
        long tv = 0L;
        long bpr = 0L;
        long sbpr = 0L;
        long txBodySize = 0L;
        txBodySize = SmartContractFeeBuilder.getCommonTransactionBodyBytes(txBody);
        bpt = txBodySize + (long)this.getContractUpdateBodyTxSize(txBody) + (long)sigValObj.getSignatureSize();
        vpt = sigValObj.getTotalSigCount();
        bpr = 4L;
        if (contractExpiryTime != null && contractExpiryTime.getSeconds() > 0L) {
            sbs = this.getContractUpdateStorageBytesSec(txBody, contractExpiryTime);
        }
        long rbsNetwork = SmartContractFeeBuilder.getDefaultRbhNetworkSize();
        rbs = (long)SmartContractFeeBuilder.getBaseTransactionRecordSize(txBody) * 90180L;
        FeeComponents feeMatricesForTx = FeeComponents.newBuilder().setBpt(bpt).setVpt(vpt).setRbh(rbs).setSbh(sbs).setGas(gas).setTv(tv).setBpr(bpr).setSbpr(sbpr).build();
        return SmartContractFeeBuilder.getFeeDataMatrices(feeMatricesForTx, sigValObj.getPayerAcctSigCount(), rbsNetwork);
    }

    public FeeData getContractCallTxFeeMatrices(TransactionBody txBody, SigValueObj sigValObj) {
        long bpt = 0L;
        long vpt = 0L;
        long rbs = 0L;
        long sbs = 0L;
        long gas = 0L;
        long tv = 0L;
        long bpr = 0L;
        long sbpr = 0L;
        long txBodySize = 0L;
        txBodySize = SmartContractFeeBuilder.getCommonTransactionBodyBytes(txBody);
        bpt = txBodySize + (long)this.getContractCallBodyTxSize(txBody) + (long)sigValObj.getSignatureSize();
        vpt = sigValObj.getTotalSigCount();
        bpr = 4L;
        rbs = (long)SmartContractFeeBuilder.getBaseTransactionRecordSize(txBody) * 90180L;
        long rbsNetwork = SmartContractFeeBuilder.getDefaultRbhNetworkSize();
        FeeComponents feeMatricesForTx = FeeComponents.newBuilder().setBpt(bpt).setVpt(vpt).setRbh(rbs).setSbh(sbs).setGas(gas).setTv(tv).setBpr(bpr).setSbpr(sbpr).build();
        return SmartContractFeeBuilder.getFeeDataMatrices(feeMatricesForTx, sigValObj.getPayerAcctSigCount(), rbsNetwork);
    }

    public FeeData getContractCallLocalFeeMatrices(int funcParamSize, ContractFunctionResult contractFuncResult, ResponseType responseType) {
        long bpt = 0L;
        long vpt = 0L;
        long rbs = 0L;
        long sbs = 0L;
        long gas = 0L;
        long tv = 0L;
        long bpr = 0L;
        long sbpr = 0L;
        bpt = 244L + (long)funcParamSize + 8L;
        long errorMessageSize = 0L;
        int contractFuncResultSize = 0;
        if (contractFuncResult != null) {
            if (contractFuncResult.getContractCallResult() != null) {
                contractFuncResultSize = contractFuncResult.getContractCallResult().size();
            }
            if (contractFuncResult.getErrorMessage() != null) {
                errorMessageSize = contractFuncResult.getErrorMessage().length();
            }
        }
        bpr = 16L + (long)SmartContractFeeBuilder.getStateProofSize(responseType);
        sbpr = 24L + errorMessageSize + 8L + (long)contractFuncResultSize;
        FeeComponents feeMatrices = FeeComponents.newBuilder().setBpt(bpt).setVpt(vpt).setRbh(rbs).setSbh(sbs).setGas(gas).setTv(tv).setBpr(bpr).setSbpr(sbpr).build();
        return SmartContractFeeBuilder.getQueryFeeDataMatrices(feeMatrices);
    }

    private int getContractUpdateBodyTxSize(TransactionBody txBody) {
        int contractUpdateBodySize = 24;
        ContractUpdateTransactionBody contractUpdateTxBody = txBody.getContractUpdateInstance();
        if (contractUpdateTxBody.hasProxyAccountID()) {
            contractUpdateBodySize += 24;
        }
        if (contractUpdateTxBody.hasFileID()) {
            contractUpdateBodySize += 24;
        }
        if (contractUpdateTxBody.hasExpirationTime()) {
            contractUpdateBodySize += 8;
        }
        if (contractUpdateTxBody.hasAutoRenewPeriod()) {
            contractUpdateBodySize += 8;
        }
        if (contractUpdateTxBody.hasAdminKey()) {
            contractUpdateBodySize += SmartContractFeeBuilder.getAccountKeyStorageSize(contractUpdateTxBody.getAdminKey());
        }
        if (contractUpdateTxBody.getMemo() != null) {
            contractUpdateBodySize += contractUpdateTxBody.getMemoBytes().size();
        }
        return contractUpdateBodySize;
    }

    private int getContractCallBodyTxSize(TransactionBody txBody) {
        int contractCallBodySize = 76;
        ContractCallTransactionBody contractCallTxBody = txBody.getContractCall();
        if (contractCallTxBody.getFunctionParameters() != null) {
            contractCallBodySize += contractCallTxBody.getFunctionParameters().size();
        }
        if (contractCallTxBody.getAmount() != 0L) {
            contractCallBodySize += 8;
        }
        return contractCallBodySize;
    }

    private int getEthereumTransactionBodyTxSize(TransactionBody txBody) {
        EthereumTransactionBody ethereumTransactionBody = txBody.getEthereumTransaction();
        return 144 + ethereumTransactionBody.getEthereumData().size();
    }

    public FeeData getContractByteCodeQueryFeeMatrices(int byteCodeSize, ResponseType responseType) {
        long bpt = 0L;
        long vpt = 0L;
        long rbs = 0L;
        long sbs = 0L;
        long gas = 0L;
        long tv = 0L;
        long bpr = 0L;
        long sbpr = 0L;
        bpt = SmartContractFeeBuilder.calculateBpt();
        bpr = 16L + (long)SmartContractFeeBuilder.getStateProofSize(responseType);
        sbpr = byteCodeSize;
        FeeComponents feeMatrices = FeeComponents.newBuilder().setBpt(bpt).setVpt(vpt).setRbh(rbs).setSbh(sbs).setGas(gas).setTv(tv).setBpr(bpr).setSbpr(sbpr).build();
        return SmartContractFeeBuilder.getQueryFeeDataMatrices(feeMatrices);
    }

    private long getContractUpdateStorageBytesSec(TransactionBody txBody, Timestamp contractExpiryTime) {
        long storageSize = 0L;
        ContractUpdateTransactionBody contractUpdateTxBody = txBody.getContractUpdateInstance();
        if (contractUpdateTxBody.hasAdminKey()) {
            storageSize += (long)SmartContractFeeBuilder.getAccountKeyStorageSize(contractUpdateTxBody.getAdminKey());
        }
        if (contractUpdateTxBody.getMemo() != null) {
            storageSize += (long)contractUpdateTxBody.getMemoBytes().size();
        }
        Instant expirationTime = RequestBuilder.convertProtoTimeStamp(contractExpiryTime);
        Timestamp txValidStartTimestamp = txBody.getTransactionID().getTransactionValidStart();
        Instant txValidStartTime = RequestBuilder.convertProtoTimeStamp(txValidStartTimestamp);
        Duration duration = Duration.between(txValidStartTime, expirationTime);
        long seconds = Math.min(duration.getSeconds(), 3153600000L);
        return storageSize *= seconds;
    }

    public FeeData getContractDeleteTxFeeMatrices(TransactionBody txBody, SigValueObj sigValObj) {
        long bpt = 0L;
        long vpt = 0L;
        long rbs = 0L;
        long sbs = 0L;
        long gas = 0L;
        long tv = 0L;
        long bpr = 0L;
        long sbpr = 0L;
        long txBodySize = 0L;
        txBodySize = SmartContractFeeBuilder.getCommonTransactionBodyBytes(txBody);
        bpt = txBodySize + 24L + 24L + (long)sigValObj.getSignatureSize();
        vpt = sigValObj.getTotalSigCount();
        bpr = 4L;
        rbs = SmartContractFeeBuilder.calculateRbs(txBody);
        long rbsNetwork = SmartContractFeeBuilder.getDefaultRbhNetworkSize() + 4320L;
        FeeComponents feeMatricesForTx = FeeComponents.newBuilder().setBpt(bpt).setVpt(vpt).setRbh(rbs).setSbh(sbs).setGas(gas).setTv(tv).setBpr(bpr).setSbpr(sbpr).build();
        return SmartContractFeeBuilder.getFeeDataMatrices(feeMatricesForTx, sigValObj.getPayerAcctSigCount(), rbsNetwork);
    }

    public FeeData getEthereumTransactionFeeMatrices(TransactionBody txBody, SigValueObj sigValObj) {
        long bpt = 0L;
        long vpt = 0L;
        long rbs = 0L;
        long sbs = 0L;
        long gas = 0L;
        long tv = 0L;
        long bpr = 0L;
        long sbpr = 0L;
        long txBodySize = 0L;
        txBodySize = SmartContractFeeBuilder.getCommonTransactionBodyBytes(txBody);
        bpt = txBodySize + (long)this.getEthereumTransactionBodyTxSize(txBody) + (long)sigValObj.getSignatureSize();
        vpt = (long)sigValObj.getTotalSigCount() + 1L;
        bpr = 4L;
        rbs = (long)SmartContractFeeBuilder.getBaseTransactionRecordSize(txBody) * 90180L;
        long rbsNetwork = SmartContractFeeBuilder.getDefaultRbhNetworkSize();
        FeeComponents feeMatricesForTx = FeeComponents.newBuilder().setBpt(bpt).setVpt(vpt).setRbh(rbs).setSbh(sbs).setGas(gas).setTv(tv).setBpr(bpr).setSbpr(sbpr).build();
        return SmartContractFeeBuilder.getFeeDataMatrices(feeMatricesForTx, sigValObj.getPayerAcctSigCount(), rbsNetwork);
    }
}

