/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hapi.utils.keys;

import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.KeyList;
import com.hedera.hapi.node.base.ThresholdKey;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import java.util.Comparator;
import java.util.List;

public class KeyComparator
implements Comparator<Key> {
    @Override
    public int compare(Key first, Key second) {
        Key.KeyOneOfType secondKeyType;
        if (first == second) {
            return 0;
        }
        if (first == null) {
            return -1;
        }
        if (second == null) {
            return 1;
        }
        if (first.key() == null) {
            return second.key() == null ? 0 : -1;
        }
        if (second.key() == null) {
            return 1;
        }
        Key.KeyOneOfType firstKeyType = (Key.KeyOneOfType)first.key().kind();
        if (firstKeyType != (secondKeyType = (Key.KeyOneOfType)second.key().kind())) {
            return this.compareCrossType(firstKeyType, secondKeyType);
        }
        return switch (firstKeyType) {
            default -> throw new MatchException(null, null);
            case Key.KeyOneOfType.UNSET -> 0;
            case Key.KeyOneOfType.CONTRACT_ID -> this.compareContractId(first, second);
            case Key.KeyOneOfType.DELEGATABLE_CONTRACT_ID -> this.compareDelegateable(first, second);
            case Key.KeyOneOfType.ED25519 -> this.compareEdwards(first, second);
            case Key.KeyOneOfType.ECDSA_SECP256K1 -> this.compareSecp256k(first, second);
            case Key.KeyOneOfType.THRESHOLD_KEY -> this.compareThreshold(first, second);
            case Key.KeyOneOfType.KEY_LIST -> this.compareKeyList(first, second);
            case Key.KeyOneOfType.RSA_3072 -> this.compareRsa(first, second);
            case Key.KeyOneOfType.ECDSA_384 -> this.compareEcdsa(first, second);
        };
    }

    private int compareContractId(Key first, Key second) {
        ContractID rhs;
        ContractID lhs = first.contractID();
        if (lhs == (rhs = second.contractID())) {
            return 0;
        }
        if (lhs == null) {
            return -1;
        }
        if (rhs == null) {
            return 1;
        }
        return this.compareId(lhs, rhs);
    }

    private int compareDelegateable(Key first, Key second) {
        ContractID rhs;
        ContractID lhs = first.delegatableContractId();
        if (lhs == (rhs = second.delegatableContractId())) {
            return 0;
        }
        if (lhs == null) {
            return -1;
        }
        if (rhs == null) {
            return 1;
        }
        return this.compareId(lhs, rhs);
    }

    private int compareId(ContractID leftId, ContractID rightId) {
        long secondId;
        long realmOne = leftId.realmNum();
        long realmTwo = rightId.realmNum();
        long shardOne = leftId.shardNum();
        long shardTwo = rightId.shardNum();
        Bytes evmOne = leftId.evmAddress();
        Bytes evmTwo = rightId.evmAddress();
        Long leftNum = leftId.contractNum();
        Long rightNum = rightId.contractNum();
        long firstId = leftNum != null ? leftNum : -1L;
        long l = secondId = rightNum != null ? rightNum : -1L;
        if (realmOne == realmTwo) {
            if (shardOne == shardTwo) {
                if (firstId == secondId) {
                    return this.compareBytes(evmOne, evmTwo);
                }
                return Long.compare(firstId, secondId);
            }
            return Long.compare(shardOne, shardTwo);
        }
        return Long.compare(realmOne, realmTwo);
    }

    private int compareEdwards(Key first, Key second) {
        Bytes lhs = first.ed25519();
        Bytes rhs = second.ed25519();
        return this.compareBytes(lhs, rhs);
    }

    private int compareSecp256k(Key first, Key second) {
        Bytes lhs = first.ecdsaSecp256k1();
        Bytes rhs = second.ecdsaSecp256k1();
        return this.compareBytes(lhs, rhs);
    }

    private int compareThreshold(Key first, Key second) {
        KeyList rightList;
        int rightThreshold;
        ThresholdKey rhs;
        ThresholdKey lhs = first.thresholdKey();
        if (lhs == (rhs = second.thresholdKey())) {
            return 0;
        }
        if (lhs == null) {
            return -1;
        }
        if (rhs == null) {
            return 1;
        }
        int leftThreshold = lhs.threshold();
        if (leftThreshold != (rightThreshold = rhs.threshold())) {
            return leftThreshold > rightThreshold ? 1 : -1;
        }
        KeyList leftList = lhs.keys();
        if (leftList == (rightList = rhs.keys())) {
            return 0;
        }
        if (leftList == null) {
            return -1;
        }
        if (rightList == null) {
            return 1;
        }
        return this.compareListOfKeys(leftList.keys(), rightList.keys());
    }

    private int compareKeyList(Key first, Key second) {
        KeyList rhs;
        KeyList lhs = first.keyList();
        if (lhs == (rhs = second.keyList())) {
            return 0;
        }
        if (lhs == null) {
            return -1;
        }
        if (rhs == null) {
            return 1;
        }
        return this.compareListOfKeys(lhs.keys(), rhs.keys());
    }

    private int compareEcdsa(Key first, Key second) {
        throw new UnsupportedOperationException("Key Type ECDSA 384 is not supported");
    }

    private int compareRsa(Key first, Key second) {
        throw new UnsupportedOperationException("Key Type RSA 3072 is not supported");
    }

    private int compareListOfKeys(List<Key> lhs, List<Key> rhs) {
        int rightLength;
        if (lhs == rhs) {
            return 0;
        }
        if (lhs == null) {
            return -1;
        }
        if (rhs == null) {
            return 1;
        }
        int leftLength = lhs.size();
        if (leftLength != (rightLength = rhs.size())) {
            return leftLength - rightLength;
        }
        for (int i = 0; i < leftLength; ++i) {
            int comparison = this.compare(lhs.get(i), rhs.get(i));
            if (comparison == 0) continue;
            return comparison;
        }
        return 0;
    }

    private int compareBytes(Bytes lhs, Bytes rhs) {
        long rightLength;
        if (lhs == rhs) {
            return 0;
        }
        if (lhs == null) {
            return -1;
        }
        if (rhs == null) {
            return 1;
        }
        long leftLength = lhs.length();
        if (leftLength != (rightLength = rhs.length())) {
            return leftLength > rightLength ? -1 : 1;
        }
        for (long offset = 0L; offset < leftLength; ++offset) {
            byte right;
            byte left = lhs.getByte(offset);
            if (left == (right = rhs.getByte(offset))) continue;
            return Byte.compareUnsigned(left, right) > 0 ? 1 : -1;
        }
        return 0;
    }

    private int compareCrossType(Key.KeyOneOfType firstKeyType, Key.KeyOneOfType secondKeyType) {
        return Integer.compare(firstKeyType.protoOrdinal(), secondKeyType.protoOrdinal());
    }
}

