/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hapi.utils.throttles;

import com.hedera.node.app.hapi.utils.CommonUtils;
import com.hedera.node.app.hapi.utils.throttles.DiscreteLeakyBucket;

public class LeakyBucketThrottle {
    private static final long TIME_TO_EMPTY = 1000000000L;
    public static final int DEFAULT_BURST_SECONDS = 1;
    private final DiscreteLeakyBucket bucket;
    private long lastAllowedUnits = 0L;
    private final int burstSeconds;

    public LeakyBucketThrottle(long capacity) {
        this(capacity, 1);
    }

    public LeakyBucketThrottle(long capacity, int burstSeconds) {
        this.validateCapacityForRequested(capacity, burstSeconds);
        this.burstSeconds = burstSeconds;
        this.bucket = DiscreteLeakyBucket.ofFixedCapacity(capacity * (long)burstSeconds);
    }

    private void validateCapacityForRequested(long capacity, int burstSeconds) {
        if (CommonUtils.productWouldOverflow(capacity, burstSeconds)) {
            throw new IllegalArgumentException("Base bucket capacity calculation outside numeric range");
        }
    }

    public boolean allow(long txLimit, long elapsedNanos) {
        this.leakFor(elapsedNanos);
        if (this.bucket.brimfulCapacityFree() >= txLimit) {
            this.bucket.useCapacity(txLimit);
            this.lastAllowedUnits += txLimit;
            return true;
        }
        return false;
    }

    void leakFor(long elapsedNanos) {
        this.bucket.leak(this.effectiveLeak(elapsedNanos));
    }

    long capacityFree() {
        return this.bucket.brimfulCapacityFree();
    }

    double percentUsed(long givenElapsedNanos) {
        return 100.0 * (double)this.capacityUsed(givenElapsedNanos) / (double)this.bucket.brimfulCapacity();
    }

    long capacityFree(long givenElapsedNanos) {
        return this.bucket.brimfulCapacity() - this.capacityUsed(givenElapsedNanos);
    }

    long capacityUsed(long givenElapsedNanos) {
        long used = this.bucket.capacityUsed();
        return used - Math.min(used, this.effectiveLeak(givenElapsedNanos));
    }

    double instantaneousPercentUsed() {
        return 100.0 * (double)this.bucket.capacityUsed() / (double)this.bucket.brimfulCapacity();
    }

    public long freeToUsedRatio() {
        long used = this.bucket.capacityUsed();
        return used == 0L ? Long.MAX_VALUE : this.bucket.brimfulCapacityFree() / used;
    }

    void resetLastAllowedUse() {
        this.lastAllowedUnits = 0L;
    }

    void reclaimLastAllowedUse() {
        this.bucket.leak(this.lastAllowedUnits);
        this.lastAllowedUnits = 0L;
    }

    public DiscreteLeakyBucket bucket() {
        return this.bucket;
    }

    private long effectiveLeak(long elapsedNanos) {
        if (elapsedNanos >= 1000000000L) {
            return this.bucket.brimfulCapacity();
        }
        return CommonUtils.productWouldOverflow(elapsedNanos, this.bucket.brimfulCapacity()) ? 9223372036L : elapsedNanos * this.bucket.brimfulCapacity() / (long)this.burstSeconds / 1000000000L;
    }
}

