/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hapi.utils.throttles;

import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.state.throttles.ThrottleUsageSnapshot;
import com.hedera.node.app.hapi.utils.CommonUtils;
import com.hedera.node.app.hapi.utils.throttles.CongestibleThrottle;
import com.hedera.node.app.hapi.utils.throttles.DeterministicThrottle;
import com.hedera.node.app.hapi.utils.throttles.DiscreteLeakyBucket;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Instant;
import java.util.Objects;

public class OpsDurationDeterministicThrottle
implements CongestibleThrottle {
    private final String throttleName;
    private final long capacityFreedPerSecond;
    private final DiscreteLeakyBucket bucket;
    private Instant lastDecisionTime;

    public OpsDurationDeterministicThrottle(String name, long nominalCapacity, long capacityFreedPerSecond) {
        this.throttleName = name;
        this.capacityFreedPerSecond = capacityFreedPerSecond;
        this.bucket = DiscreteLeakyBucket.ofNominalAndBrimfulCapacity(nominalCapacity, Long.MAX_VALUE);
    }

    public void useCapacity(@NonNull Instant now, long unitsToConsume) {
        long elapsedNanos = DeterministicThrottle.nanosBetween(this.lastDecisionTime, now);
        if (elapsedNanos < 0L) {
            throw new IllegalArgumentException("Throttle timeline must advance, but " + String.valueOf(now) + " is not after " + String.valueOf(now));
        }
        this.lastDecisionTime = now;
        this.bucket.leak(this.effectiveLeak(elapsedNanos));
        this.bucket.useCapacity(Math.min(this.bucket.brimfulCapacityFree(), unitsToConsume));
    }

    public long capacityFree(@NonNull Instant now) {
        if (this.lastDecisionTime == null) {
            return this.bucket.nominalCapacityFree();
        }
        long elapsedNanos = Math.max(0L, DeterministicThrottle.nanosBetween(this.lastDecisionTime, now));
        return Math.max(0L, this.bucket.nominalCapacity() - this.capacityUsed(elapsedNanos));
    }

    public long capacityUsed(long givenElapsedNanos) {
        long used = this.bucket.capacityUsed();
        return used - Math.min(used, this.effectiveLeak(givenElapsedNanos));
    }

    @Override
    public double instantaneousPercentUsed() {
        if (this.lastDecisionTime == null) {
            return 0.0;
        }
        return 100.0 * (double)this.bucket.capacityUsed() / (double)this.bucket.nominalCapacity();
    }

    @Override
    public long capacity() {
        return this.bucket.nominalCapacity();
    }

    @Override
    public long mtps() {
        return 0L;
    }

    @Override
    public String name() {
        return this.throttleName;
    }

    @Override
    public long used() {
        return this.bucket.capacityUsed();
    }

    public ThrottleUsageSnapshot usageSnapshot() {
        return new ThrottleUsageSnapshot(this.bucket.capacityUsed(), this.lastDecisionTime == null ? null : new Timestamp(this.lastDecisionTime.getEpochSecond(), this.lastDecisionTime.getNano()));
    }

    public void resetUsageTo(@NonNull ThrottleUsageSnapshot usageSnapshot) {
        Objects.requireNonNull(usageSnapshot);
        this.lastDecisionTime = usageSnapshot.lastDecisionTime() == null ? null : Instant.ofEpochSecond(usageSnapshot.lastDecisionTime().seconds(), usageSnapshot.lastDecisionTime().nanos());
        this.bucket.resetUsed(usageSnapshot.used());
    }

    private long effectiveLeak(long elapsedNanos) {
        return CommonUtils.productWouldOverflow(elapsedNanos, this.capacityFreedPerSecond) ? 9223372036L : elapsedNanos * this.capacityFreedPerSecond / 1000000000L;
    }
}

