/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.file.impl;

import com.hedera.hapi.node.base.FileID;
import com.hedera.hapi.node.state.file.File;
import com.hedera.node.app.hapi.utils.EntityType;
import com.hedera.node.app.service.file.impl.ReadableFileStoreImpl;
import com.hedera.node.app.service.file.impl.schemas.V0490FileSchema;
import com.hedera.node.app.spi.ids.ReadableEntityCounters;
import com.hedera.node.app.spi.ids.WritableEntityCounters;
import com.swirlds.state.spi.ReadableStates;
import com.swirlds.state.spi.WritableKVState;
import com.swirlds.state.spi.WritableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class WritableFileStore
extends ReadableFileStoreImpl {
    private final WritableKVState<FileID, File> filesState;
    private final WritableEntityCounters entityCounters;

    public WritableFileStore(@NonNull WritableStates states, @NonNull WritableEntityCounters entityCounters) {
        super((ReadableStates)states, (ReadableEntityCounters)entityCounters);
        this.filesState = Objects.requireNonNull(states.get(V0490FileSchema.FILES_STATE_ID));
        this.entityCounters = entityCounters;
    }

    public void put(@NonNull File file) {
        this.filesState.put((Object)Objects.requireNonNull(file).fileId(), (Object)file);
    }

    public void putAndIncrementCount(@NonNull File file) {
        this.put(file);
        this.entityCounters.incrementEntityTypeCount(EntityType.FILE);
    }

    @NonNull
    public Optional<File> get(FileID fileId) {
        File file = (File)this.filesState.get((Object)fileId);
        return Optional.ofNullable(file);
    }

    @NonNull
    public Set<FileID> modifiedFiles() {
        return this.filesState.modifiedKeys();
    }

    public void removeFile(FileID fileId) {
        this.filesState.remove((Object)fileId);
        this.entityCounters.decrementEntityTypeCounter(EntityType.FILE);
    }
}

