/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.file.impl.utils;

import com.hedera.hapi.node.base.FileID;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.KeyList;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.ThresholdKey;
import com.hedera.hapi.node.state.file.File;
import com.hedera.node.app.service.file.ReadableFileStore;
import com.hedera.node.app.service.file.impl.WritableFileStore;
import com.hedera.node.app.spi.validation.Validations;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.PreHandleContext;
import com.hedera.node.config.data.FilesConfig;
import com.hedera.node.config.data.HederaConfig;
import com.hedera.node.config.data.LedgerConfig;
import com.swirlds.config.api.Configuration;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.Optional;

public class FileServiceUtils {
    private FileServiceUtils() {
    }

    public static void validateContent(@NonNull byte[] content, @NonNull FilesConfig fileServiceConfig) {
        int contentLength = content.length;
        if ((long)contentLength > (long)fileServiceConfig.maxSizeKb() * 1024L) {
            throw new HandleException(ResponseCodeEnum.MAX_FILE_SIZE_EXCEEDED);
        }
    }

    public static void preValidate(@NonNull FileID fileId, @NonNull ReadableFileStore fileStore, @NonNull PreHandleContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        Objects.requireNonNull(fileId);
        if (FileServiceUtils.notGenesisCreation(fileId, context.configuration())) {
            Validations.mustExist((Object)fileStore.getFileMetadata(fileId), (ResponseCodeEnum)ResponseCodeEnum.INVALID_FILE_ID);
        }
    }

    public static void validateAndAddRequiredKeys(@Nullable File file, @Nullable KeyList transactionKeys, @NonNull PreHandleContext context) throws PreCheckException {
        KeyList fileKeyList;
        if (file != null && (fileKeyList = file.keys()) != null) {
            for (Key key : fileKeyList.keys()) {
                context.requireKey(key);
            }
        }
        if (transactionKeys != null) {
            for (Key key : transactionKeys.keys()) {
                context.requireKey(key);
            }
        }
    }

    public static void validateAndAddRequiredKeysForDelete(@Nullable File file, @NonNull PreHandleContext context) throws PreCheckException {
        KeyList fileKeyList;
        if (file != null && (fileKeyList = file.keys()) != null) {
            ThresholdKey syntheticKey = ThresholdKey.newBuilder().threshold(1).keys(fileKeyList).build();
            context.requireKey(Key.newBuilder().thresholdKey(syntheticKey).build());
        }
    }

    @NonNull
    public static File verifyNotSystemFile(@NonNull LedgerConfig ledgerConfig, @NonNull WritableFileStore fileStore, @NonNull FileID fileId, boolean canBeDeleted) {
        if (fileId.fileNum() <= ledgerConfig.numReservedSystemEntities()) {
            throw new HandleException(ResponseCodeEnum.ENTITY_NOT_ALLOWED_TO_DELETE);
        }
        Optional<File> optionalFile = fileStore.get(fileId);
        if (optionalFile.isEmpty()) {
            throw new HandleException(ResponseCodeEnum.INVALID_FILE_ID);
        }
        File file = optionalFile.get();
        if (!file.hasKeys() || file.keys().keys().isEmpty()) {
            throw new HandleException(ResponseCodeEnum.UNAUTHORIZED);
        }
        if (!canBeDeleted && file.deleted()) {
            throw new HandleException(ResponseCodeEnum.FILE_DELETED);
        }
        return file;
    }

    @NonNull
    public static File verifyNotSystemFile(@NonNull LedgerConfig ledgerConfig, @NonNull WritableFileStore fileStore, @NonNull FileID fileId) {
        return FileServiceUtils.verifyNotSystemFile(ledgerConfig, fileStore, fileId, false);
    }

    public static boolean notGenesisCreation(FileID fileID, @NonNull Configuration config) {
        HederaConfig hederaConfig = (HederaConfig)config.getConfigData(HederaConfig.class);
        if (fileID.shardNum() != hederaConfig.shard() || fileID.realmNum() != hederaConfig.realm()) {
            return true;
        }
        long fileNum = fileID.fileNum();
        FilesConfig filesConfig = (FilesConfig)config.getConfigData(FilesConfig.class);
        return !filesConfig.softwareUpdateRange().containsInclusive(fileNum) && fileNum != filesConfig.addressBook() && fileNum != filesConfig.nodeDetails() && fileNum != filesConfig.feeSchedules() && fileNum != filesConfig.exchangeRates() && fileNum != filesConfig.networkProperties() && fileNum != filesConfig.hapiPermissions() && fileNum != filesConfig.throttleDefinitions();
    }
}

