/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.store;

import com.hedera.node.app.hints.WritableHintsStore;
import com.hedera.node.app.hints.impl.WritableHintsStoreImpl;
import com.hedera.node.app.history.WritableHistoryStore;
import com.hedera.node.app.history.impl.WritableHistoryStoreImpl;
import com.hedera.node.app.service.addressbook.impl.WritableAccountNodeRelStore;
import com.hedera.node.app.service.addressbook.impl.WritableNodeStore;
import com.hedera.node.app.service.consensus.impl.WritableTopicStore;
import com.hedera.node.app.service.contract.impl.state.WritableContractStateStore;
import com.hedera.node.app.service.contract.impl.state.WritableEvmHookStore;
import com.hedera.node.app.service.entityid.WritableEntityCounters;
import com.hedera.node.app.service.entityid.impl.WritableEntityIdStoreImpl;
import com.hedera.node.app.service.file.impl.WritableFileStore;
import com.hedera.node.app.service.file.impl.WritableUpgradeFileStore;
import com.hedera.node.app.service.networkadmin.impl.WritableFreezeStore;
import com.hedera.node.app.service.schedule.WritableScheduleStore;
import com.hedera.node.app.service.schedule.impl.WritableScheduleStoreImpl;
import com.hedera.node.app.service.token.impl.WritableAccountStore;
import com.hedera.node.app.service.token.impl.WritableAirdropStore;
import com.hedera.node.app.service.token.impl.WritableNetworkStakingRewardsStore;
import com.hedera.node.app.service.token.impl.WritableNftStore;
import com.hedera.node.app.service.token.impl.WritableStakingInfoStore;
import com.hedera.node.app.service.token.impl.WritableTokenRelationStore;
import com.hedera.node.app.service.token.impl.WritableTokenStore;
import com.swirlds.state.State;
import com.swirlds.state.spi.WritableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.hiero.consensus.roster.WritableRosterStore;

public class WritableStoreFactory {
    private static final Map<Class<?>, StoreEntry> STORE_FACTORY = WritableStoreFactory.createFactoryMap();
    private final String serviceName;
    private final WritableStates states;
    private final WritableEntityCounters entityCounters;

    private static Map<Class<?>, StoreEntry> createFactoryMap() {
        HashMap<Class, StoreEntry> newMap = new HashMap<Class, StoreEntry>();
        newMap.put(WritableNodeStore.class, new StoreEntry("AddressBookService", WritableNodeStore::new));
        newMap.put(WritableAccountNodeRelStore.class, new StoreEntry("AddressBookService", (states, entityCounters) -> new WritableAccountNodeRelStore(states)));
        newMap.put(WritableTopicStore.class, new StoreEntry("ConsensusService", WritableTopicStore::new));
        newMap.put(WritableAccountStore.class, new StoreEntry("TokenService", WritableAccountStore::new));
        newMap.put(WritableAirdropStore.class, new StoreEntry("TokenService", WritableAirdropStore::new));
        newMap.put(WritableNftStore.class, new StoreEntry("TokenService", WritableNftStore::new));
        newMap.put(WritableTokenStore.class, new StoreEntry("TokenService", WritableTokenStore::new));
        newMap.put(WritableTokenRelationStore.class, new StoreEntry("TokenService", WritableTokenRelationStore::new));
        newMap.put(WritableNetworkStakingRewardsStore.class, new StoreEntry("TokenService", (states, entityCounters) -> new WritableNetworkStakingRewardsStore(states)));
        newMap.put(WritableStakingInfoStore.class, new StoreEntry("TokenService", WritableStakingInfoStore::new));
        newMap.put(WritableFreezeStore.class, new StoreEntry("FreezeService", (states, entityCounters) -> new WritableFreezeStore(states)));
        newMap.put(WritableFileStore.class, new StoreEntry("FileService", WritableFileStore::new));
        newMap.put(WritableUpgradeFileStore.class, new StoreEntry("FileService", (states, entityCounters) -> new WritableUpgradeFileStore(states)));
        newMap.put(WritableContractStateStore.class, new StoreEntry("ContractService", WritableContractStateStore::new));
        newMap.put(WritableEvmHookStore.class, new StoreEntry("ContractService", WritableEvmHookStore::new));
        newMap.put(WritableEntityIdStoreImpl.class, new StoreEntry("EntityIdService", (states, entityCounters) -> new WritableEntityIdStoreImpl(states)));
        newMap.put(WritableScheduleStore.class, new StoreEntry("ScheduleService", WritableScheduleStoreImpl::new));
        newMap.put(WritableRosterStore.class, new StoreEntry("RosterService", (states, entityCounters) -> new WritableRosterStore(states)));
        newMap.put(WritableHintsStore.class, new StoreEntry("HintsService", WritableHintsStoreImpl::new));
        newMap.put(WritableHistoryStore.class, new StoreEntry("HistoryService", (states, entityCounters) -> new WritableHistoryStoreImpl(states)));
        return Collections.unmodifiableMap(newMap);
    }

    public WritableStoreFactory(@NonNull State state, @NonNull String serviceName, @NonNull WritableEntityCounters entityCounters) {
        Objects.requireNonNull(state);
        this.serviceName = Objects.requireNonNull(serviceName, "The argument 'serviceName' cannot be null!");
        this.states = state.getWritableStates(serviceName);
        this.entityCounters = Objects.requireNonNull(entityCounters);
    }

    @NonNull
    public <C> C getStore(@NonNull Class<C> storeInterface) throws IllegalArgumentException {
        Objects.requireNonNull(storeInterface, "The supplied argument 'storeInterface' cannot be null!");
        StoreEntry entry = STORE_FACTORY.get(storeInterface);
        if (entry != null && this.serviceName.equals(entry.name())) {
            Object store = entry.factory().create(this.states, this.entityCounters);
            if (!storeInterface.isInstance(store)) {
                throw new IllegalArgumentException("No instance " + String.valueOf(storeInterface) + " is available");
            }
            return storeInterface.cast(store);
        }
        throw new IllegalArgumentException("No store of the given class is available " + storeInterface.getName());
    }

    public String getServiceName() {
        return this.serviceName;
    }

    private record StoreEntry(@NonNull String name, @NonNull StoreFactory factory) {
    }

    private static interface StoreFactory {
        public Object create(@NonNull WritableStates var1, @NonNull WritableEntityCounters var2);
    }
}

