/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.workflows.prehandle;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.node.app.hapi.utils.keys.KeyUtils;
import com.hedera.node.app.signature.SignatureVerificationFuture;
import com.hedera.node.app.spi.workflows.PreHandleContext;
import com.hedera.node.app.state.HederaRecordCache;
import com.hedera.node.app.workflows.TransactionInfo;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public record PreHandleResult(@Nullable AccountID payer, @Nullable Key payerKey, @NonNull Status status, @NonNull ResponseCodeEnum responseCode, @Nullable TransactionInfo txInfo, @Nullable Set<Key> requiredKeys, @Nullable Set<Key> optionalKeys, @Nullable Set<Account> hollowAccounts, @Nullable Map<Key, SignatureVerificationFuture> verificationResults, @Nullable List<PreHandleResult> innerResults, long configVersion) {
    private static final long UNKNOWN_VERSION = -1L;

    public PreHandleResult {
        Objects.requireNonNull(status);
        Objects.requireNonNull(responseCode);
    }

    public boolean hasReusableVerificationResultsFor(@NonNull PreHandleContext context) {
        return this.getPayerKey().equals((Object)context.payerKey()) && this.getRequiredKeys().equals(context.requiredNonPayerKeys()) && this.getOptionalKeys().equals(context.optionalNonPayerKeys()) && this.getHollowAccounts().equals(context.requiredHollowAccounts());
    }

    public HederaRecordCache.DueDiligenceFailure dueDiligenceFailure() {
        return this.status == Status.NODE_DUE_DILIGENCE_FAILURE ? HederaRecordCache.DueDiligenceFailure.YES : HederaRecordCache.DueDiligenceFailure.NO;
    }

    @NonNull
    public TransactionInfo txnInfoOrThrow() {
        return Objects.requireNonNull(this.txInfo);
    }

    @NonNull
    public Map<Key, SignatureVerificationFuture> getVerificationResults() {
        return this.verificationResults == null ? Collections.emptyMap() : this.verificationResults;
    }

    @NonNull
    public Set<Key> getRequiredKeys() {
        return this.requiredKeys == null ? Collections.emptySet() : this.requiredKeys;
    }

    @NonNull
    public Set<Key> getOptionalKeys() {
        return this.optionalKeys == null ? Collections.emptySet() : this.optionalKeys;
    }

    @NonNull
    public Key getPayerKey() {
        return this.payerKey == null ? KeyUtils.IMMUTABILITY_SENTINEL_KEY : this.payerKey;
    }

    public Set<Account> getHollowAccounts() {
        return this.hollowAccounts == null ? Collections.emptySet() : this.hollowAccounts;
    }

    @NonNull
    public static PreHandleResult unknownFailure() {
        return new PreHandleResult(null, null, Status.UNKNOWN_FAILURE, ResponseCodeEnum.UNKNOWN, null, null, null, null, null, null, -1L);
    }

    @NonNull
    public static PreHandleResult nodeDueDiligenceFailure(@NonNull AccountID node, @NonNull ResponseCodeEnum responseCode, @Nullable TransactionInfo txInfo, long configVersion) {
        return new PreHandleResult(node, null, Status.NODE_DUE_DILIGENCE_FAILURE, responseCode, txInfo, null, null, null, null, null, configVersion);
    }

    @NonNull
    public static PreHandleResult preHandleFailure(@NonNull AccountID payer, @Nullable Key payerKey, @NonNull ResponseCodeEnum responseCode, @NonNull TransactionInfo txInfo, @Nullable Set<Key> requiredKeys, @Nullable Set<Key> optionalKeys, @Nullable Set<Account> hollowAccounts, @Nullable Map<Key, SignatureVerificationFuture> verificationResults) {
        return new PreHandleResult(payer, payerKey, Status.PRE_HANDLE_FAILURE, responseCode, txInfo, requiredKeys, optionalKeys, hollowAccounts, verificationResults, null, -1L);
    }

    @NonNull
    public static PreHandleResult shortCircuitingTransaction(@Nullable TransactionInfo txInfo) {
        return new PreHandleResult(null, null, Status.SO_FAR_SO_GOOD, ResponseCodeEnum.UNKNOWN, txInfo, null, null, null, null, null, -1L);
    }

    public static enum Status {
        UNKNOWN_FAILURE,
        NODE_DUE_DILIGENCE_FAILURE,
        PAYER_UNWILLING_OR_UNABLE_TO_PAY_SERVICE_FEE,
        PRE_HANDLE_FAILURE,
        SO_FAR_SO_GOOD;

    }
}

