/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.handlers;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.NftID;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.SubType;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.TokenType;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.state.token.Nft;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.hapi.node.state.token.TokenRelation;
import com.hedera.hapi.node.token.TokenWipeAccountTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.hapi.fees.usage.SingletonUsageProperties;
import com.hedera.node.app.hapi.fees.usage.token.TokenOpsUsageUtils;
import com.hedera.node.app.hapi.fees.usage.token.meta.TokenWipeMeta;
import com.hedera.node.app.hapi.utils.CommonPbjConverters;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.service.token.ReadableTokenRelationStore;
import com.hedera.node.app.service.token.ReadableTokenStore;
import com.hedera.node.app.service.token.impl.WritableAccountStore;
import com.hedera.node.app.service.token.impl.WritableNftStore;
import com.hedera.node.app.service.token.impl.WritableTokenRelationStore;
import com.hedera.node.app.service.token.impl.WritableTokenStore;
import com.hedera.node.app.service.token.impl.handlers.transfer.NFTOwnersChangeStep;
import com.hedera.node.app.service.token.impl.util.TokenHandlerHelper;
import com.hedera.node.app.service.token.impl.validators.TokenSupplyChangeOpsValidator;
import com.hedera.node.app.service.token.records.TokenAccountWipeStreamBuilder;
import com.hedera.node.app.spi.fees.FeeContext;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.store.StoreFactory;
import com.hedera.node.app.spi.validation.ExpiryValidator;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.PreHandleContext;
import com.hedera.node.app.spi.workflows.PureChecksContext;
import com.hedera.node.app.spi.workflows.TransactionHandler;
import com.hedera.node.config.data.TokensConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public final class TokenAccountWipeHandler
implements TransactionHandler {
    @NonNull
    private final TokenSupplyChangeOpsValidator validator;

    @Inject
    public TokenAccountWipeHandler(@NonNull TokenSupplyChangeOpsValidator validator) {
        this.validator = validator;
    }

    public void preHandle(@NonNull PreHandleContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        TokenWipeAccountTransactionBody op = context.body().tokenWipeOrThrow();
        ReadableTokenStore tokenStore = (ReadableTokenStore)context.createStore(ReadableTokenStore.class);
        ReadableTokenStore.TokenMetadata tokenMeta = tokenStore.getTokenMeta(op.tokenOrElse(TokenID.DEFAULT));
        if (tokenMeta == null) {
            throw new PreCheckException(ResponseCodeEnum.INVALID_TOKEN_ID);
        }
        if (tokenMeta.hasWipeKey()) {
            context.requireKey(tokenMeta.wipeKey());
        }
    }

    public void pureChecks(@NonNull PureChecksContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        TransactionBody txn = context.body();
        TokenWipeAccountTransactionBody op = txn.tokenWipeOrThrow();
        TokenSupplyChangeOpsValidator.verifyTokenInstanceAmounts(op.amount(), op.serialNumbers(), op.hasToken(), ResponseCodeEnum.INVALID_WIPING_AMOUNT);
        PreCheckException.validateTruePreCheck((boolean)op.hasAccount(), (ResponseCodeEnum)ResponseCodeEnum.INVALID_ACCOUNT_ID);
    }

    public void handle(@NonNull HandleContext context) throws HandleException {
        long newAccountBalance;
        long newTotalSupply;
        Objects.requireNonNull(context);
        StoreFactory storeFactory = context.storeFactory();
        WritableAccountStore accountStore = (WritableAccountStore)storeFactory.writableStore(WritableAccountStore.class);
        WritableTokenStore tokenStore = (WritableTokenStore)storeFactory.writableStore(WritableTokenStore.class);
        WritableTokenRelationStore tokenRelStore = (WritableTokenRelationStore)storeFactory.writableStore(WritableTokenRelationStore.class);
        WritableNftStore nftStore = (WritableNftStore)storeFactory.writableStore(WritableNftStore.class);
        ExpiryValidator expiryValidator = context.expiryValidator();
        TokensConfig tokensConfig = (TokensConfig)context.configuration().getConfigData(TokensConfig.class);
        TransactionBody txn = context.body();
        TokenWipeAccountTransactionBody op = txn.tokenWipeOrThrow();
        AccountID accountId = op.account();
        TokenID tokenId = op.token();
        long fungibleWipeCount = op.amount();
        ArrayList<Long> nftSerialNums = new ArrayList<Long>(new LinkedHashSet(op.serialNumbers()));
        ValidationResult validated = this.validateSemantics(accountId, tokenId, fungibleWipeCount, nftSerialNums, accountStore, tokenStore, tokenRelStore, expiryValidator, tokensConfig);
        Account acct = validated.account();
        Token token = validated.token();
        AccountID unaliasedId = acct.accountIdOrThrow();
        if (token.tokenType() == TokenType.FUNGIBLE_COMMON) {
            HandleException.validateTrue((fungibleWipeCount >= 0L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_WIPING_AMOUNT);
            newTotalSupply = token.totalSupply() - fungibleWipeCount;
            HandleException.validateTrue((newTotalSupply >= 0L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_WIPING_AMOUNT);
            newAccountBalance = validated.accountTokenRel().balance() - fungibleWipeCount;
            HandleException.validateTrue((newAccountBalance >= 0L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_WIPING_AMOUNT);
        } else {
            HandleException.validateFalse((boolean)nftSerialNums.isEmpty(), (ResponseCodeEnum)ResponseCodeEnum.INVALID_WIPING_AMOUNT);
            newTotalSupply = token.totalSupply() - (long)nftSerialNums.size();
            HandleException.validateTrue((newTotalSupply >= 0L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_WIPING_AMOUNT);
            for (Long nftSerial : nftSerialNums) {
                NftID nftId = NftID.newBuilder().serialNumber(nftSerial.longValue()).tokenId(tokenId).build();
                Nft nft = TokenHandlerHelper.getIfUsable(nftId, nftStore);
                AccountID nftOwner = nft.ownerId();
                HandleException.validateTrue((boolean)Objects.equals(nftOwner, unaliasedId), (ResponseCodeEnum)ResponseCodeEnum.ACCOUNT_DOES_NOT_OWN_WIPED_NFT);
            }
            newAccountBalance = validated.accountTokenRel().balance() - (long)nftSerialNums.size();
            HandleException.validateTrue((newAccountBalance >= 0L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_WIPING_AMOUNT);
            nftSerialNums.forEach(serialNum -> {
                if (!unaliasedId.equals((Object)token.treasuryAccountId())) {
                    NFTOwnersChangeStep.removeFromList(NftID.newBuilder().serialNumber(serialNum.longValue()).tokenId(tokenId).build(), nftStore, acct, accountStore);
                }
                nftStore.remove(tokenId, (long)serialNum);
            });
        }
        Account.Builder updatedAcctBuilder = Objects.requireNonNull(accountStore.getAccountById(unaliasedId)).copyBuilder();
        updatedAcctBuilder.numberOwnedNfts(acct.numberOwnedNfts() - (long)nftSerialNums.size());
        if (newAccountBalance == 0L) {
            updatedAcctBuilder.numberPositiveBalances(Math.max(acct.numberPositiveBalances() - 1, 0));
        }
        accountStore.put(updatedAcctBuilder.build());
        tokenStore.put(token.copyBuilder().totalSupply(newTotalSupply).build());
        tokenRelStore.put(validated.accountTokenRel().copyBuilder().balance(newAccountBalance).build());
        TokenAccountWipeStreamBuilder baseBuilderRecord = (TokenAccountWipeStreamBuilder)context.savepointStack().getBaseBuilder(TokenAccountWipeStreamBuilder.class);
        baseBuilderRecord.newTotalSupply(newTotalSupply);
        baseBuilderRecord.tokenType(token.tokenType());
    }

    @NonNull
    public Fees calculateFees(@NonNull FeeContext feeContext) {
        TransactionBody op = feeContext.body();
        ReadableTokenStore readableTokenStore = (ReadableTokenStore)feeContext.readableStore(ReadableTokenStore.class);
        TokenType tokenType = Optional.ofNullable(readableTokenStore.get(op.tokenWipeOrThrow().tokenOrElse(TokenID.DEFAULT))).map(Token::tokenType).orElse(TokenType.FUNGIBLE_COMMON);
        TokenWipeMeta meta = TokenOpsUsageUtils.TOKEN_OPS_USAGE_UTILS.tokenWipeUsageFrom(CommonPbjConverters.fromPbj((TransactionBody)op));
        return feeContext.feeCalculatorFactory().feeCalculator(tokenType.equals((Object)TokenType.FUNGIBLE_COMMON) ? SubType.TOKEN_FUNGIBLE_COMMON : SubType.TOKEN_NON_FUNGIBLE_UNIQUE).addBytesPerTransaction((long)meta.getBpt()).addNetworkRamByteSeconds(meta.getTransferRecordDb() * SingletonUsageProperties.USAGE_PROPERTIES.legacyReceiptStorageSecs()).calculate();
    }

    private ValidationResult validateSemantics(@NonNull AccountID accountId, @NonNull TokenID tokenId, long fungibleWipeCount, @NonNull List<Long> nftSerialNums, @NonNull ReadableAccountStore accountStore, @NonNull ReadableTokenStore tokenStore, @NonNull ReadableTokenRelationStore tokenRelStore, @NonNull ExpiryValidator expiryValidator, @NonNull TokensConfig tokensConfig) {
        HandleException.validateTrue((fungibleWipeCount > -1L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_WIPING_AMOUNT);
        Account account = TokenHandlerHelper.getIfUsableForAliasedId(accountId, accountStore, expiryValidator, ResponseCodeEnum.INVALID_ACCOUNT_ID);
        this.validator.validateWipe(fungibleWipeCount, nftSerialNums, tokensConfig);
        Token token = TokenHandlerHelper.getIfUsable(tokenId, tokenStore);
        HandleException.validateTrue((token.wipeKey() != null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.TOKEN_HAS_NO_WIPE_KEY);
        TokenRelation accountRel = TokenHandlerHelper.getIfUsable(account.accountIdOrThrow(), tokenId, tokenRelStore);
        if (token.hasKycKey()) {
            HandleException.validateTrue((boolean)accountRel.kycGranted(), (ResponseCodeEnum)ResponseCodeEnum.ACCOUNT_KYC_NOT_GRANTED_FOR_TOKEN);
        }
        HandleException.validateFalse((boolean)token.treasuryAccountId().equals((Object)accountRel.accountId()), (ResponseCodeEnum)ResponseCodeEnum.CANNOT_WIPE_TOKEN_TREASURY_ACCOUNT);
        return new ValidationResult(account, token, accountRel);
    }

    private record ValidationResult(@NonNull Account account, @NonNull Token token, @NonNull TokenRelation accountTokenRel) {
    }
}

