/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.getapproved;

import com.esaulpaugh.headlong.abi.Address;
import com.esaulpaugh.headlong.abi.Tuple;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.TokenType;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.state.token.Nft;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.node.app.service.contract.impl.exec.gas.SystemContractGasCalculator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.FullResult;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.AbstractRevertibleTokenViewCall;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.getapproved.GetApprovedTranslator;
import com.hedera.node.app.service.contract.impl.hevm.HederaWorldUpdater;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;

public class GetApprovedCall
extends AbstractRevertibleTokenViewCall {
    private final long serialNo;
    private final boolean isErcCall;
    private final boolean isStaticCall;

    public GetApprovedCall(@NonNull SystemContractGasCalculator gasCalculator, @NonNull HederaWorldUpdater.Enhancement enhancement, @Nullable Token token, long serialNo, boolean isErcCall, boolean isStaticCall) {
        super(gasCalculator, enhancement, token);
        this.serialNo = serialNo;
        this.isErcCall = isErcCall;
        this.isStaticCall = isStaticCall;
    }

    @Override
    @NonNull
    protected Call.PricedResult resultOfViewingToken(@NonNull Token token) {
        Account spender;
        Objects.requireNonNull(token);
        if (token.tokenType() != TokenType.NON_FUNGIBLE_UNIQUE) {
            if (!this.isStaticCall) {
                return Call.PricedResult.gasOnly(FullResult.revertResult(ResponseCodeEnum.INVALID_TOKEN_NFT_SERIAL_NUMBER, this.gasCalculator.viewGasRequirement()), ResponseCodeEnum.INVALID_TOKEN_NFT_SERIAL_NUMBER, true);
            }
            return Call.PricedResult.gasOnly(FullResult.revertResult(ResponseCodeEnum.INVALID_TOKEN_ID, this.gasCalculator.viewGasRequirement()), ResponseCodeEnum.INVALID_TOKEN_ID, true);
        }
        Nft nft = this.nativeOperations().getNft(token.tokenId(), this.serialNo);
        if (nft == null || !nft.hasNftId()) {
            return Call.PricedResult.gasOnly(FullResult.revertResult(ResponseCodeEnum.INVALID_TOKEN_NFT_SERIAL_NUMBER, this.gasCalculator.viewGasRequirement()), ResponseCodeEnum.INVALID_TOKEN_NFT_SERIAL_NUMBER, true);
        }
        Address spenderAddress = ConversionUtils.asHeadlongAddress(new byte[20]);
        if (nft.spenderId() != null && (spender = this.nativeOperations().getAccount(nft.spenderIdOrThrow())) != null) {
            spenderAddress = ConversionUtils.headlongAddressOf(spender);
        }
        return this.isErcCall ? Call.PricedResult.gasOnly(FullResult.successResult(GetApprovedTranslator.ERC_GET_APPROVED.getOutputs().encode((Object)Tuple.singleton((Object)spenderAddress)), this.gasCalculator.viewGasRequirement()), ResponseCodeEnum.SUCCESS, true) : Call.PricedResult.gasOnly(FullResult.successResult(GetApprovedTranslator.HAPI_GET_APPROVED.getOutputs().encode((Object)Tuple.of((Object)ResponseCodeEnum.SUCCESS.protoOrdinal(), (Object)spenderAddress)), this.gasCalculator.viewGasRequirement()), ResponseCodeEnum.SUCCESS, true);
    }
}

