/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.handlers;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.SubType;
import com.hedera.hapi.node.contract.ContractDeleteTransactionBody;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.hapi.utils.CommonPbjConverters;
import com.hedera.node.app.hapi.utils.fee.SmartContractFeeBuilder;
import com.hedera.node.app.service.addressbook.ReadableAccountNodeRelStore;
import com.hedera.node.app.service.contract.impl.records.ContractDeleteStreamBuilder;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import com.hedera.node.app.service.entityid.EntityIdFactory;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.service.token.api.TokenServiceApi;
import com.hedera.node.app.spi.fees.FeeContext;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.validation.Validations;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.PreHandleContext;
import com.hedera.node.app.spi.workflows.PureChecksContext;
import com.hedera.node.app.spi.workflows.TransactionHandler;
import com.hedera.node.app.spi.workflows.record.DeleteCapableTransactionStreamBuilder;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ContractDeleteHandler
implements TransactionHandler {
    private final SmartContractFeeBuilder usageEstimator = new SmartContractFeeBuilder();
    private final EntityIdFactory entityIdFactory;

    @Inject
    public ContractDeleteHandler(@NonNull EntityIdFactory entityIdFactory) {
        this.entityIdFactory = entityIdFactory;
    }

    public void pureChecks(@NonNull PureChecksContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        TransactionBody txn = context.body();
        ContractDeleteTransactionBody op = txn.contractDeleteInstanceOrThrow();
        PreCheckException.validateFalsePreCheck((boolean)op.permanentRemoval(), (ResponseCodeEnum)ResponseCodeEnum.PERMANENT_REMOVAL_REQUIRES_SYSTEM_INITIATION);
        ContractID contractID = op.contractID();
        Validations.mustExist((Object)contractID, (ResponseCodeEnum)ResponseCodeEnum.INVALID_CONTRACT_ID);
        PreCheckException.validateTruePreCheck((op.hasTransferAccountID() || op.hasTransferContractID() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.OBTAINER_REQUIRED);
    }

    public void preHandle(@NonNull PreHandleContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        ContractDeleteTransactionBody op = context.body().contractDeleteInstanceOrThrow();
        Account contract = ((ReadableAccountStore)context.createStore(ReadableAccountStore.class)).getContractById(op.contractIDOrThrow());
        Validations.mustExist((Object)contract, (ResponseCodeEnum)ResponseCodeEnum.INVALID_CONTRACT_ID);
        context.requireKeyOrThrow(contract.key(), ResponseCodeEnum.MODIFYING_IMMUTABLE_CONTRACT);
        Key adminKey = contract.keyOrThrow();
        PreCheckException.validateFalsePreCheck((adminKey.hasContractID() || adminKey.hasDelegatableContractId() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.MODIFYING_IMMUTABLE_CONTRACT);
        if (op.hasTransferAccountID()) {
            context.requireKeyIfReceiverSigRequired(op.transferAccountID(), ResponseCodeEnum.INVALID_TRANSFER_ACCOUNT_ID);
        } else if (op.hasTransferContractID()) {
            context.requireKeyIfReceiverSigRequired(op.transferContractID(), ResponseCodeEnum.INVALID_CONTRACT_ID);
        }
    }

    public void handle(@NonNull HandleContext context) throws HandleException {
        ContractDeleteTransactionBody op = context.body().contractDeleteInstanceOrThrow();
        ReadableAccountStore accountStore = (ReadableAccountStore)context.storeFactory().readableStore(ReadableAccountStore.class);
        Account toBeDeleted = Objects.requireNonNull(accountStore.getContractById(op.contractIDOrThrow()));
        HandleException.validateFalse((boolean)toBeDeleted.deleted(), (ResponseCodeEnum)ResponseCodeEnum.CONTRACT_DELETED);
        Account obtainer = this.getObtainer(accountStore, op);
        HandleException.validateTrue((obtainer != null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.OBTAINER_DOES_NOT_EXIST);
        if (obtainer.deleted()) {
            throw new HandleException(obtainer.smartContract() ? ResponseCodeEnum.INVALID_CONTRACT_ID : ResponseCodeEnum.OBTAINER_DOES_NOT_EXIST);
        }
        HandleException.validateFalse((boolean)toBeDeleted.accountIdOrThrow().equals((Object)obtainer.accountIdOrThrow()), (ResponseCodeEnum)ResponseCodeEnum.OBTAINER_SAME_CONTRACT_ID);
        ContractDeleteStreamBuilder recordBuilder = (ContractDeleteStreamBuilder)context.savepointStack().getBaseBuilder(ContractDeleteStreamBuilder.class);
        AccountID deletedId = toBeDeleted.accountIdOrThrow();
        ReadableAccountNodeRelStore accountNodeRelStore = (ReadableAccountNodeRelStore)context.storeFactory().readableStore(ReadableAccountNodeRelStore.class);
        ((TokenServiceApi)context.storeFactory().serviceApi(TokenServiceApi.class)).deleteAndTransfer(deletedId, obtainer.accountIdOrThrow(), context.expiryValidator(), (DeleteCapableTransactionStreamBuilder)recordBuilder, accountNodeRelStore);
        recordBuilder.contractID(ConversionUtils.asNumericContractId(this.entityIdFactory, deletedId));
    }

    @Nullable
    private Account getObtainer(@NonNull ReadableAccountStore accountStore, @NonNull ContractDeleteTransactionBody op) {
        return op.hasTransferAccountID() ? accountStore.getAccountById(op.transferAccountIDOrThrow()) : accountStore.getContractById(op.transferContractIDOrThrow());
    }

    @NonNull
    public Fees calculateFees(@NonNull FeeContext feeContext) {
        Objects.requireNonNull(feeContext);
        TransactionBody op = feeContext.body();
        return feeContext.feeCalculatorFactory().feeCalculator(SubType.DEFAULT).legacyCalculate(sigValueObj -> this.usageEstimator.getContractDeleteTxFeeMatrices(CommonPbjConverters.fromPbj((TransactionBody)op), sigValueObj));
    }
}

