/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.http;

import io.helidon.common.security.SecurityContext;
import io.helidon.webserver.http.Handler;
import io.helidon.webserver.http.ServerRequest;
import io.helidon.webserver.http.ServerResponse;
import java.util.Optional;

public final class SecureHandler
implements Handler {
    private static final String[] NO_ROLES = new String[0];
    private final boolean authenticate;
    private final boolean authorize;
    private final String[] roleHint;

    private SecureHandler(boolean authenticate, boolean authorize, String[] roleHint) {
        this.authenticate = authenticate;
        this.authorize = authorize;
        this.roleHint = roleHint;
    }

    public static SecureHandler authenticate() {
        return new SecureHandler(true, false, NO_ROLES);
    }

    public static SecureHandler authorize(String ... roleHint) {
        return new SecureHandler(false, true, roleHint);
    }

    public SecureHandler andAuthenticate() {
        return new SecureHandler(true, this.authorize, this.roleHint);
    }

    public SecureHandler andAuthorize(String ... roleHint) {
        return new SecureHandler(this.authenticate, true, roleHint);
    }

    public Handler wrap(Handler handler) {
        return new WrappedHandler(this, handler);
    }

    @Override
    public void handle(ServerRequest req, ServerResponse res) throws Exception {
        if (this.doHandle(req, res)) {
            res.next();
        }
    }

    private boolean doHandle(ServerRequest req, ServerResponse res) {
        Optional securityContext = req.context().get(SecurityContext.class);
        if (this.authenticate && !securityContext.map(SecurityContext::isAuthenticated).orElse(false).booleanValue() && !req.security().authenticate(req, res, true)) {
            return false;
        }
        return !this.authorize || securityContext.map(SecurityContext::isAuthorized).orElse(false) != false || req.security().authorize(req, res, this.roleHint);
    }

    private static class WrappedHandler
    implements Handler {
        private final SecureHandler secureHandler;
        private final Handler handler;

        private WrappedHandler(SecureHandler secureHandler, Handler handler) {
            this.secureHandler = secureHandler;
            this.handler = handler;
        }

        @Override
        public void handle(ServerRequest req, ServerResponse res) throws Exception {
            if (this.secureHandler.doHandle(req, res)) {
                this.handler.handle(req, res);
            }
        }
    }
}

