/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.gascalculator;

import java.util.function.Supplier;
import org.apache.tuweni.units.bigints.UInt256;
import org.hyperledger.besu.evm.gascalculator.BerlinGasCalculator;

public class LondonGasCalculator
extends BerlinGasCalculator {
    private static final long SSTORE_CLEARS_SCHEDULE = 4800L;
    private static final long NEGATIVE_SSTORE_CLEARS_SCHEDULE = -4800L;
    private static final int NEW_MAX_REFUND_QUOTIENT = 5;

    protected LondonGasCalculator(int maxPrecompile) {
        super(maxPrecompile);
    }

    public LondonGasCalculator() {
    }

    @Override
    public long getSelfDestructRefundAmount() {
        return 0L;
    }

    @Override
    public long calculateStorageRefundAmount(UInt256 newValue, Supplier<UInt256> currentValue, Supplier<UInt256> originalValue) {
        UInt256 localCurrentValue = currentValue.get();
        if (localCurrentValue.equals((Object)newValue)) {
            return 0L;
        }
        UInt256 localOriginalValue = originalValue.get();
        if (localOriginalValue.equals((Object)localCurrentValue)) {
            if (localOriginalValue.isZero()) {
                return 0L;
            }
            if (newValue.isZero()) {
                return 4800L;
            }
            return 0L;
        }
        long refund = 0L;
        if (!localOriginalValue.isZero()) {
            if (localCurrentValue.isZero()) {
                refund = -4800L;
            } else if (newValue.isZero()) {
                refund = 4800L;
            }
        }
        if (localOriginalValue.equals((Object)newValue)) {
            refund += localOriginalValue.isZero() ? 19900L : 2800L;
        }
        return refund;
    }

    @Override
    public long getMaxRefundQuotient() {
        return 5L;
    }
}

