/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.worldstate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import org.hyperledger.besu.collections.undo.UndoMap;
import org.hyperledger.besu.collections.undo.UndoSet;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.datatypes.Wei;
import org.hyperledger.besu.evm.account.Account;
import org.hyperledger.besu.evm.account.MutableAccount;
import org.hyperledger.besu.evm.internal.EvmConfiguration;
import org.hyperledger.besu.evm.worldstate.AbstractWorldUpdater;
import org.hyperledger.besu.evm.worldstate.JournaledAccount;
import org.hyperledger.besu.evm.worldstate.UpdateTrackingAccount;
import org.hyperledger.besu.evm.worldstate.WorldUpdater;
import org.hyperledger.besu.evm.worldstate.WorldView;

public class JournaledUpdater<W extends WorldView>
implements WorldUpdater {
    final EvmConfiguration evmConfiguration;
    final WorldUpdater parentWorld;
    final AbstractWorldUpdater<W, ? extends MutableAccount> rootWorld;
    final UndoMap<Address, JournaledAccount> accounts;
    final UndoSet<Address> deleted;
    final long undoMark;

    public JournaledUpdater(WorldUpdater world, EvmConfiguration evmConfiguration) {
        this.parentWorld = world;
        this.evmConfiguration = evmConfiguration;
        if (world instanceof JournaledUpdater) {
            JournaledUpdater journaledUpdater = (JournaledUpdater)world;
            this.accounts = journaledUpdater.accounts;
            this.deleted = journaledUpdater.deleted;
            this.rootWorld = journaledUpdater.rootWorld;
        } else if (world instanceof AbstractWorldUpdater) {
            this.accounts = new UndoMap(new HashMap());
            this.deleted = UndoSet.of(new HashSet());
            this.rootWorld = (AbstractWorldUpdater)world;
        } else {
            throw new IllegalArgumentException("WorldUpdater must be a JournaledWorldUpdater or an AbstractWorldUpdater");
        }
        this.undoMark = this.accounts.mark();
    }

    protected MutableAccount getForMutation(Address address) {
        JournaledAccount wrappedTracker = this.accounts.get(address);
        if (wrappedTracker != null) {
            return wrappedTracker;
        }
        MutableAccount account = this.rootWorld.getForMutation(address);
        return account == null ? null : new UpdateTrackingAccount<MutableAccount>(account);
    }

    @Override
    public Collection<? extends Account> getTouchedAccounts() {
        return new ArrayList<JournaledAccount>(this.accounts.values());
    }

    @Override
    public Collection<Address> getDeletedAccountAddresses() {
        return new ArrayList<Address>(this.deleted);
    }

    protected void reset() {
        this.accounts.values().forEach(a -> a.undo(this.undoMark));
        this.accounts.undo(this.undoMark);
        this.deleted.undo(this.undoMark);
    }

    @Override
    public void revert() {
        this.reset();
    }

    @Override
    public void commit() {
        if (!(this.parentWorld instanceof JournaledUpdater)) {
            this.accounts.values().forEach(JournaledAccount::commit);
            this.deleted.forEach(this.parentWorld::deleteAccount);
        }
    }

    @Override
    public Optional<WorldUpdater> parentUpdater() {
        return Optional.of(this.parentWorld);
    }

    @Override
    public void markTransactionBoundary() {
        this.accounts.values().forEach(JournaledAccount::markTransactionBoundary);
    }

    @Override
    public MutableAccount createAccount(Address address, long nonce, Wei balance) {
        JournaledAccount journaledAccount = new JournaledAccount(this.rootWorld.createAccount(address, nonce, balance));
        this.accounts.put(address, journaledAccount);
        return new JournaledAccount(journaledAccount);
    }

    @Override
    public MutableAccount getAccount(Address address) {
        JournaledAccount existing = this.accounts.get(address);
        if (existing != null) {
            return existing;
        }
        if (this.deleted.contains(address)) {
            return null;
        }
        MutableAccount origin = this.rootWorld.getAccount(address);
        if (origin == null) {
            return null;
        }
        JournaledAccount newAccount = new JournaledAccount(origin);
        this.accounts.put(address, newAccount);
        return newAccount;
    }

    @Override
    public void deleteAccount(Address address) {
        this.deleted.add(address);
        JournaledAccount account = this.accounts.get(address);
        if (account != null) {
            account.setDeleted(true);
        }
    }

    @Override
    public Account get(Address address) {
        MutableAccount existing = this.accounts.get(address);
        if (existing != null) {
            return existing;
        }
        if (this.deleted.contains(address)) {
            return null;
        }
        return this.rootWorld.get(address);
    }

    @Override
    public WorldUpdater updater() {
        return new JournaledUpdater<W>(this, this.evmConfiguration);
    }
}

